/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.gun;

import com.craftingdead.core.network.Synched;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.gun.FireMode;
import com.craftingdead.core.world.gun.GunClient;
import com.craftingdead.core.world.gun.PendingHit;
import com.craftingdead.core.world.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.gun.attachment.Attachment;
import com.craftingdead.core.world.gun.skin.Skin;
import com.craftingdead.core.world.inventory.GunCraftSlotType;
import com.craftingdead.core.world.item.combatslot.CombatSlotProvider;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public interface Gun
extends CombatSlotProvider,
Synched {
    public void tick(LivingExtension<?, ?> var1);

    public void reset(LivingExtension<?, ?> var1);

    public void setTriggerPressed(LivingExtension<?, ?> var1, boolean var2, boolean var3);

    public boolean isTriggerPressed();

    public void validatePendingHit(PlayerExtension<ServerPlayerEntity> var1, LivingExtension<?, ?> var2, PendingHit var3);

    public float getAccuracy(LivingExtension<?, ?> var1, Random var2);

    public Set<Attachment> getAttachments();

    default public float getAttachmentMultiplier(Attachment.MultiplierType multiplierType) {
        return this.getAttachments().stream().map(attachment -> Float.valueOf(attachment.getMultiplier(multiplierType))).reduce(Float.valueOf(1.0f), (x, y) -> Float.valueOf(x.floatValue() * y.floatValue())).floatValue();
    }

    public void setAttachments(Set<Attachment> var1);

    default public boolean hasIronSight() {
        for (Attachment attachmentItem : this.getAttachments()) {
            if (attachmentItem.getInventorySlot() != GunCraftSlotType.OVERBARREL_ATTACHMENT) continue;
            return false;
        }
        return true;
    }

    public ItemStack getPaintStack();

    public void setPaintStack(ItemStack var1);

    @Nullable
    public Skin getSkin();

    public void setSkin(Skin var1);

    default public Optional<ResourceLocation> getSkinName() {
        return this.getPaintStack().func_190926_b() ? Optional.empty() : Optional.of(this.getPaintStack().func_77973_b().getRegistryName());
    }

    public boolean isAcceptedAttachment(ItemStack var1);

    public FireMode getFireMode();

    public void setFireMode(LivingExtension<?, ?> var1, FireMode var2, boolean var3);

    public void toggleFireMode(LivingExtension<?, ?> var1, boolean var2);

    public boolean isPerformingSecondaryAction();

    public void setPerformingSecondaryAction(LivingExtension<?, ?> var1, boolean var2, boolean var3);

    public SecondaryActionTrigger getSecondaryActionTrigger();

    public Optional<SoundEvent> getReloadSound();

    public int getReloadDurationTicks();

    public GunClient getClient();

    public AmmoProvider getAmmoProvider();

    public void setAmmoProvider(AmmoProvider var1);

    public Set<? extends Item> getAcceptedMagazines();

    public ItemStack getDefaultMagazineStack();

    public ItemStack getItemStack();

    public static enum SecondaryActionTrigger {
        HOLD,
        TOGGLE;

    }
}

