/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.gun;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.client.ClientDist;
import com.craftingdead.core.client.animation.AnimationType;
import com.craftingdead.core.client.animation.GunAnimation;
import com.craftingdead.core.client.animation.GunAnimationController;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.ValidatePendingHitMessage;
import com.craftingdead.core.sounds.ModSoundEvents;
import com.craftingdead.core.world.entity.extension.EntitySnapshot;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.gun.AbstractGun;
import com.craftingdead.core.world.gun.GunClient;
import com.craftingdead.core.world.gun.PendingHit;
import com.craftingdead.core.world.gun.attachment.Attachment;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class AbstractGunClient<T extends AbstractGun>
implements GunClient {
    private static final int MUZZLE_FLASH_DURATION_TICKS = 2;
    protected final ClientDist client = CraftingDead.getInstance().getClientDist();
    protected final Minecraft minecraft = Minecraft.func_71410_x();
    protected final T gun;
    private final GunAnimationController animationController = new GunAnimationController();
    private int lastShotCount;
    private int remainingFlashTicks;
    private long secondaryActionSoundStartTimeMs;
    private final Multimap<Integer, PendingHit> livingHitValidationBuffer = Multimaps.synchronizedListMultimap((ListMultimap)Multimaps.newListMultimap((Map)new Int2ObjectLinkedOpenHashMap(), ObjectArrayList::new));
    private byte hitValidationTicks = 0;

    public AbstractGunClient(T gun) {
        this.gun = gun;
    }

    protected abstract Optional<SoundEvent> getSecondaryActionSound();

    protected abstract long getSecondaryActionSoundRepeatDelayMs();

    public void handleTick(LivingExtension<?, ?> living) {
        if (living.getEntity() instanceof ClientPlayerEntity && this.livingHitValidationBuffer.size() > 0) {
            byte by = this.hitValidationTicks;
            this.hitValidationTicks = (byte)(by + 1);
            if (by >= 3) {
                this.hitValidationTicks = 0;
                NetworkChannel.PLAY.getSimpleChannel().sendToServer((Object)new ValidatePendingHitMessage(new HashMap<Integer, Collection<PendingHit>>(this.livingHitValidationBuffer.asMap())));
                this.livingHitValidationBuffer.clear();
            }
        }
        this.getSecondaryActionSound().ifPresent(sound -> {
            long delta = Util.func_211177_b() - this.secondaryActionSoundStartTimeMs + 50L;
            long repeatDelay = this.getSecondaryActionSoundRepeatDelayMs();
            if (((AbstractGun)this.gun).isPerformingSecondaryAction() && repeatDelay > 0L && delta >= repeatDelay) {
                this.secondaryActionSoundStartTimeMs = Util.func_211177_b();
                living.getEntity().func_184185_a(sound, 1.0f, 1.0f);
            }
        });
        if (!((AbstractGun)this.gun).isTriggerPressed()) {
            this.lastShotCount = 0;
        }
        if (this.remainingFlashTicks > 0) {
            --this.remainingFlashTicks;
        }
        this.animationController.tick((LivingEntity)living.getEntity(), ((AbstractGun)this.gun).getItemStack());
    }

    protected abstract float getRecoil();

    protected abstract SoundEvent getShootSound();

    protected abstract Optional<SoundEvent> getDistantShootSound();

    protected abstract Optional<SoundEvent> getSilencedShootSound();

    protected boolean canFlash(LivingExtension<?, ?> living) {
        return this.minecraft.field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON && ((AbstractGun)this.gun).getShotCount() != this.lastShotCount && ((AbstractGun)this.gun).getShotCount() > 0;
    }

    public void handleShoot(LivingExtension<?, ?> living) {
        SoundEvent shootSound;
        double sqrDistance;
        Object entity = living.getEntity();
        if (this.canFlash(living)) {
            this.remainingFlashTicks = 2;
        }
        this.lastShotCount = ((AbstractGun)this.gun).getShotCount();
        this.getAnimation(AnimationType.SHOOT).ifPresent(animation -> {
            this.animationController.removeCurrentAnimation();
            this.animationController.addAnimation((GunAnimation)animation, null);
        });
        if (entity == this.minecraft.func_175606_aa()) {
            this.client.getCameraManager().randomRecoil(this.getRecoil(), true);
        }
        boolean farAway = (sqrDistance = this.minecraft.field_71460_t.func_215316_n().func_216785_c().func_186679_c(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_())) > 1600.0;
        SoundEvent defaultShootSound = this.getShootSound();
        boolean amplifyDistantSound = this.getDistantShootSound().isPresent();
        if (((AbstractGun)this.gun).getAttachments().stream().anyMatch(Attachment::isSoundSuppressor)) {
            shootSound = farAway ? null : this.getSilencedShootSound().orElse(defaultShootSound);
        } else {
            SoundEvent soundEvent = shootSound = farAway ? this.getDistantShootSound().orElse(defaultShootSound) : defaultShootSound;
        }
        if (!entity.func_174814_R() && shootSound != null) {
            this.minecraft.execute(() -> entity.field_70170_p.func_184134_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), shootSound, entity.func_184176_by(), farAway && amplifyDistantSound ? 8.0f : 1.0f, 1.0f, true));
        }
    }

    public void handleHitEntityPre(LivingExtension<?, ?> living, Entity hitEntity, Vector3d hitPos, long randomSeed) {
        if (living.getEntity() instanceof ClientPlayerEntity && hitEntity instanceof LivingEntity) {
            this.livingHitValidationBuffer.put((Object)hitEntity.func_145782_y(), (Object)new PendingHit((byte)(3 - this.hitValidationTicks), new EntitySnapshot((Entity)living.getEntity()), new EntitySnapshot(hitEntity), randomSeed));
        }
    }

    public void handleHitEntityPost(LivingExtension<?, ?> living, Entity hitEntity, Vector3d hitPos, boolean playSound, boolean headshot) {
        int i;
        int particleCount;
        if (!(hitEntity instanceof LivingEntity)) {
            return;
        }
        World level = hitEntity.field_70170_p;
        if (headshot) {
            particleCount = 12;
            for (i = 0; i < 12; ++i) {
                level.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_189880_di.func_176223_P()), hitPos.func_82615_a(), hitPos.func_82617_b(), hitPos.func_82616_c(), 0.0, 0.0, 0.0);
            }
        }
        level.func_184133_a(living.getEntity() instanceof PlayerEntity ? (PlayerEntity)living.getEntity() : null, hitEntity.func_233580_cy_(), (SoundEvent)ModSoundEvents.BULLET_IMPACT_FLESH.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        if (hitEntity == this.minecraft.func_175606_aa()) {
            this.client.getCameraManager().randomRecoil(1.5f, false);
        }
        particleCount = 12;
        for (i = 0; i < 12; ++i) {
            level.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150451_bX.func_176223_P()), hitPos.func_82615_a(), hitPos.func_82617_b(), hitPos.func_82616_c(), 0.0, 0.0, 0.0);
        }
    }

    public void handleHitBlock(LivingExtension<?, ?> living, BlockRayTraceResult result, BlockState blockState, boolean playSound) {
        Object entity = living.getEntity();
        World level = ((Entity)entity).field_70170_p;
        Vector3d location = result.func_216347_e();
        if (playSound) {
            SoundEvent hitSound = (SoundEvent)ModSoundEvents.BULLET_IMPACT_DIRT.get();
            Material blockMaterial = blockState.func_185904_a();
            if (blockMaterial == Material.field_151575_d) {
                hitSound = (SoundEvent)ModSoundEvents.BULLET_IMPACT_WOOD.get();
            } else if (blockMaterial == Material.field_151576_e) {
                hitSound = (SoundEvent)ModSoundEvents.BULLET_IMPACT_STONE.get();
            } else if (blockMaterial == Material.field_151573_f) {
                hitSound = Math.random() > 0.5 ? (SoundEvent)ModSoundEvents.BULLET_IMPACT_METAL.get() : (SoundEvent)ModSoundEvents.BULLET_IMPACT_METAL2.get();
            } else if (blockMaterial == Material.field_151592_s) {
                hitSound = (SoundEvent)ModSoundEvents.BULLET_IMPACT_GLASS.get();
            }
            level.func_184133_a(entity instanceof PlayerEntity ? (PlayerEntity)entity : null, result.func_216350_a(), hitSound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        int particleCount = 12;
        for (int i = 0; i < 12; ++i) {
            level.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockState), location.func_82615_a(), location.func_82617_b(), location.func_82616_c(), 0.0, 0.0, 0.0);
        }
    }

    public void handleToggleSecondaryAction(LivingExtension<?, ?> living) {
        this.getSecondaryActionSound().ifPresent(sound -> {
            if (((AbstractGun)this.gun).isPerformingSecondaryAction()) {
                this.secondaryActionSoundStartTimeMs = Util.func_211177_b();
                living.getEntity().func_184185_a(sound, 1.0f, 1.0f);
            } else {
                this.minecraft.func_147118_V().func_195478_a(sound.getRegistryName(), SoundCategory.PLAYERS);
            }
        });
    }

    @Override
    public boolean isFlashing() {
        return this.remainingFlashTicks > 0;
    }

    @Override
    public GunAnimationController getAnimationController() {
        return this.animationController;
    }
}

