/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.extension;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.event.OpenEquipmentMenuEvent;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.SynchedData;
import com.craftingdead.core.network.message.play.AddKillFeedEntryMessage;
import com.craftingdead.core.world.damagesource.KillFeedProvider;
import com.craftingdead.core.world.entity.extension.LivingExtensionImpl;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.entity.extension.PlayerHandler;
import com.craftingdead.core.world.inventory.EquipmentMenu;
import com.craftingdead.core.world.inventory.ModEquipmentSlotType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.IItemHandler;

class PlayerExtensionImpl<E extends PlayerEntity>
extends LivingExtensionImpl<E, PlayerHandler>
implements PlayerExtension<E> {
    private final SynchedData dataManager = new SynchedData();
    private static final DataParameter<Boolean> COMBAT_MODE_ENABLED = new DataParameter(2, DataSerializers.field_187198_h);
    private boolean cachedCombatModeEnabled;

    PlayerExtensionImpl(E entity) {
        super(entity);
        this.dataManager.register(COMBAT_MODE_ENABLED, false);
    }

    @Override
    public void tick() {
        this.cachedCombatModeEnabled = false;
        super.tick();
    }

    @Override
    protected void tickHandler(ResourceLocation extensionId, PlayerHandler extension) {
        super.tickHandler(extensionId, extension);
        if (extension.isCombatModeEnabled()) {
            this.cachedCombatModeEnabled = true;
        }
    }

    @Override
    public void playerTick() {
        if (this.isCrouching()) {
            ((PlayerEntity)this.getEntity()).func_213301_b(Pose.SWIMMING);
        }
        for (PlayerHandler handler : this.handlers.values()) {
            handler.playerTick();
        }
    }

    @Override
    public boolean isMovementBlocked() {
        return !((PlayerEntity)this.getEntity()).func_175149_v() && super.isMovementBlocked();
    }

    @Override
    public boolean isCombatModeEnabled() {
        return !((PlayerEntity)this.getEntity()).func_175149_v() && (this.cachedCombatModeEnabled || this.dataManager.get(COMBAT_MODE_ENABLED) != false);
    }

    @Override
    public void setCombatModeEnabled(boolean combatModeEnabled) {
        this.dataManager.set(COMBAT_MODE_ENABLED, combatModeEnabled);
    }

    @Override
    public void openEquipmentMenu() {
        if (MinecraftForge.EVENT_BUS.post((Event)new OpenEquipmentMenuEvent(this))) {
            return;
        }
        ((PlayerEntity)this.getEntity()).func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInventory, playerEntity) -> new EquipmentMenu(windowId, ((PlayerEntity)this.getEntity()).field_71071_by, (IItemHandler)this.getItemHandler()), (ITextComponent)new TranslationTextComponent("container.equipment")));
    }

    @Override
    public void openStorage(ModEquipmentSlotType slotType) {
        ItemStack storageStack = this.getItemHandler().getStackInSlot(slotType.getIndex());
        storageStack.getCapability(Capabilities.STORAGE).ifPresent(storage -> ((PlayerEntity)this.getEntity()).func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((IContainerProvider)storage, storageStack.func_200301_q())));
    }

    @Override
    public boolean handleDeath(DamageSource source) {
        if (super.handleDeath(source)) {
            return true;
        }
        if (source instanceof KillFeedProvider) {
            NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.ALL.noArg(), (Object)new AddKillFeedEntryMessage(((KillFeedProvider)source).createKillFeedEntry((PlayerEntity)this.getEntity())));
        }
        return false;
    }

    @Override
    protected boolean keepInventory() {
        return this.getLevel().func_82736_K().func_223586_b(GameRules.field_223600_c);
    }

    @Override
    public void copyFrom(PlayerExtension<?> that, boolean wasDeath) {
        for (int i = 0; i < that.getItemHandler().getSlots(); ++i) {
            this.getItemHandler().setStackInSlot(i, that.getItemHandler().getStackInSlot(i));
        }
        for (PlayerHandler extension : this.handlers.values()) {
            extension.copyFrom(that, wasDeath);
        }
    }

    public SynchedData getDataManager() {
        return this.dataManager;
    }

    @Override
    public void encode(PacketBuffer out, boolean writeAll) {
        super.encode(out, writeAll);
        SynchedData.pack(writeAll ? this.dataManager.getAll() : this.dataManager.packDirty(), out);
    }

    @Override
    public void decode(PacketBuffer in) {
        super.decode(in);
        this.dataManager.assignValues(SynchedData.unpack(in));
    }

    @Override
    public boolean requiresSync() {
        return super.requiresSync() || this.dataManager.isDirty();
    }
}

