/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.extension;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.event.LivingExtensionEvent;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.CancelActionMessage;
import com.craftingdead.core.network.message.play.CrouchMessage;
import com.craftingdead.core.network.message.play.PerformActionMessage;
import com.craftingdead.core.sounds.ModSoundEvents;
import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.clothing.Clothing;
import com.craftingdead.core.world.entity.extension.EntitySnapshot;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.LivingHandler;
import com.craftingdead.core.world.entity.extension.Visibility;
import com.craftingdead.core.world.hat.Hat;
import com.craftingdead.core.world.inventory.ModEquipmentSlotType;
import com.craftingdead.core.world.item.ModItems;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

class LivingExtensionImpl<E extends LivingEntity, H extends LivingHandler>
implements LivingExtension<E, H> {
    private final E entity;
    protected final Map<ResourceLocation, H> handlers = new Object2ObjectArrayMap();
    protected final Map<ResourceLocation, H> dirtyHandlers = new Object2ObjectArrayMap();
    private final List<Integer> dirtySlots = new IntArrayList();
    private final EntitySnapshot[] snapshots = new EntitySnapshot[20];
    private final ItemStackHandler itemHandler = new ItemStackHandler(ModEquipmentSlotType.values().length){

        public void onContentsChanged(int slot) {
            if (!LivingExtensionImpl.this.entity.func_130014_f_().func_201670_d()) {
                LivingExtensionImpl.this.dirtySlots.add(slot);
            }
        }
    };
    protected ItemStack lastHeldStack = null;
    private Action action;
    private LivingExtension.ProgressMonitor actionProgress;
    private boolean movementBlocked;
    private boolean crouching;
    private Vector3d lastPos;
    private boolean moving;
    private Visibility cachedVisibility = Visibility.VISIBLE;
    private ItemStack lastClothingStack = ItemStack.field_190927_a;

    LivingExtensionImpl(E entity) {
        this.entity = entity;
    }

    @Override
    public void load() {
        MinecraftForge.EVENT_BUS.post((Event)new LivingExtensionEvent.Load(this));
    }

    @Override
    public void registerHandler(ResourceLocation id, H extension) {
        if (this.handlers.containsKey(id)) {
            throw new IllegalArgumentException("Handler with id " + id.toString() + " already registered");
        }
        this.handlers.put(id, extension);
    }

    @Override
    public Optional<H> getHandler(ResourceLocation id) {
        return Optional.ofNullable(this.handlers.get(id));
    }

    @Override
    public H getHandlerOrThrow(ResourceLocation id) {
        LivingHandler handler = (LivingHandler)this.handlers.get(id);
        if (handler == null) {
            throw new IllegalStateException("Missing handler with ID: " + id.toString());
        }
        return (H)handler;
    }

    @Override
    public boolean performAction(Action action, boolean force, boolean sendUpdate) {
        if (MinecraftForge.EVENT_BUS.post(new LivingExtensionEvent.PerformAction<Action>(this, action))) {
            return false;
        }
        LivingExtension.ProgressMonitor targetProgressMonitor = action.getTarget().flatMap(LivingExtension::getProgressMonitor).orElse(null);
        if (this.actionProgress != null || targetProgressMonitor != null) {
            if (!force) {
                return false;
            }
            this.actionProgress.stop();
            if (targetProgressMonitor != this.actionProgress) {
                targetProgressMonitor.stop();
            }
        }
        if (this.action != null && !force || !action.start()) {
            return false;
        }
        this.cancelAction(true);
        this.action = action;
        this.actionProgress = action.getPerformerProgress();
        action.getTarget().ifPresent(target -> target.setActionProgress(action.getTargetProgress()));
        if (sendUpdate) {
            PacketDistributor.PacketTarget target2 = this.getLevel().func_201670_d() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY_AND_SELF.with(this::getEntity);
            int targetId = action.getTarget().map(LivingExtension::getEntity).map(Entity::func_145782_y).orElse(-1);
            NetworkChannel.PLAY.getSimpleChannel().send(target2, (Object)new PerformActionMessage(action.getType(), this.getEntity().func_145782_y(), targetId));
        }
        return true;
    }

    @Override
    public void cancelAction(boolean sendUpdate) {
        if (this.action == null) {
            return;
        }
        this.action.cancel();
        this.removeAction();
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = this.getLevel().func_201670_d() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY_AND_SELF.with(this::getEntity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new CancelActionMessage(this.getEntity().func_145782_y()));
        }
    }

    @Override
    public void setActionProgress(LivingExtension.ProgressMonitor actionProgress) {
        this.actionProgress = actionProgress;
    }

    @Override
    public Optional<LivingExtension.ProgressMonitor> getProgressMonitor() {
        return Optional.ofNullable(this.actionProgress);
    }

    private void removeAction() {
        if (this.action != null) {
            this.actionProgress = null;
            this.action.getTarget().ifPresent(target -> target.setActionProgress(null));
            this.action = null;
        }
    }

    @Override
    public void setMovementBlocked(boolean movementBlocked) {
        this.movementBlocked = movementBlocked;
    }

    @Override
    public boolean isMovementBlocked() {
        return this.movementBlocked;
    }

    @Override
    public boolean isMoving() {
        return this.moving;
    }

    @Override
    public void tick() {
        ItemStack heldStack = this.getMainHandItem();
        if (heldStack != this.lastHeldStack) {
            this.getProgressMonitor().ifPresent(LivingExtension.ProgressMonitor::stop);
            if (this.lastHeldStack != null) {
                this.lastHeldStack.getCapability(Capabilities.GUN).ifPresent(gun -> gun.reset(this));
            }
            if (heldStack.getCapability(Capabilities.GUN).isPresent()) {
                this.entity.func_184185_a((SoundEvent)ModSoundEvents.GUN_EQUIP.get(), 0.25f, 1.0f);
            }
            this.lastHeldStack = heldStack;
        }
        this.movementBlocked = false;
        if (this.action != null && this.action.tick()) {
            this.removeAction();
        }
        heldStack.getCapability(Capabilities.GUN).ifPresent(gun -> gun.tick(this));
        this.updateClothing();
        this.updateHat();
        if (!this.entity.func_130014_f_().func_201670_d()) {
            this.snapshots[this.entity.func_184102_h().func_71259_af() % 20] = new EntitySnapshot((Entity)this.entity);
        }
        this.moving = !this.entity.func_213303_ch().equals((Object)this.lastPos);
        this.lastPos = this.entity.func_213303_ch();
        for (Map.Entry<ResourceLocation, H> entry : this.handlers.entrySet()) {
            this.tickHandler(entry.getKey(), (LivingHandler)entry.getValue());
        }
    }

    protected void tickHandler(ResourceLocation handlerId, H handler) {
        handler.tick();
        this.cachedVisibility = Visibility.VISIBLE;
        switch (handler.getVisibility()) {
            case INVISIBLE: {
                this.cachedVisibility = Visibility.INVISIBLE;
            }
            case PARTIALLY_VISIBLE: {
                if (this.cachedVisibility != Visibility.VISIBLE) break;
                this.cachedVisibility = Visibility.PARTIALLY_VISIBLE;
                break;
            }
        }
        if (handler.isMovementBlocked()) {
            this.movementBlocked = true;
        }
        if (handler.requiresSync()) {
            this.dirtyHandlers.put(handlerId, handler);
        }
    }

    private void updateHat() {
        ItemStack headStack = this.itemHandler.getStackInSlot(ModEquipmentSlotType.HAT.getIndex());
        Hat hat = (Hat)headStack.getCapability(Capabilities.HAT).orElse(null);
        if (headStack.func_77973_b() == ModItems.SCUBA_MASK.get() && this.entity.func_208600_a((ITag)FluidTags.field_206959_a)) {
            this.entity.func_195064_c(new EffectInstance(Effects.field_76427_o, 2, 0, false, false, false));
        } else if (hat != null && hat.hasNightVision()) {
            this.entity.func_195064_c(new EffectInstance(Effects.field_76439_r, 2, 0, false, false, false));
        }
    }

    private void updateClothing() {
        ItemStack clothingStack = this.itemHandler.getStackInSlot(ModEquipmentSlotType.CLOTHING.getIndex());
        Clothing clothing = (Clothing)clothingStack.getCapability(Capabilities.CLOTHING).orElse(null);
        if (clothingStack != this.lastClothingStack) {
            this.lastClothingStack.getCapability(Capabilities.CLOTHING).map(Clothing::getAttributeModifiers).ifPresent(arg_0 -> ((AttributeModifierManager)this.entity.func_233645_dx_()).func_233785_a_(arg_0));
            if (clothing != null) {
                this.entity.func_233645_dx_().func_233793_b_(clothing.getAttributeModifiers());
            }
        }
        if (clothing != null && clothing.hasFireImmunity()) {
            if (this.entity.func_223314_ad() > 0) {
                this.entity.func_70066_B();
            }
            this.entity.func_195064_c(new EffectInstance(Effects.field_76426_n, 2, 0, false, false, false));
        }
        if (clothingStack.func_77973_b() == ModItems.SCUBA_CLOTHING.get() && this.entity.func_208600_a((ITag)FluidTags.field_206959_a)) {
            this.entity.func_195064_c(new EffectInstance(Effects.field_206827_D, 2, 0, false, false, false));
        }
        this.lastClothingStack = clothingStack;
    }

    @Override
    public float handleDamaged(DamageSource source, float amount) {
        return this.handlers.values().stream().reduce(Float.valueOf(amount), (result, extension) -> Float.valueOf(extension.handleDamaged(source, result.floatValue())), (u, t) -> t).floatValue();
    }

    @Override
    public boolean handleHurt(DamageSource source, float amount) {
        return this.handlers.values().stream().anyMatch(e -> e.handleHurt(source, amount));
    }

    @Override
    public boolean handleKill(Entity target) {
        return this.handlers.values().stream().anyMatch(e -> e.handleKill(target));
    }

    @Override
    public boolean handleDeath(DamageSource cause) {
        return this.handlers.values().stream().map(e -> e.handleDeath(cause)).anyMatch(v -> v == true);
    }

    @Override
    public boolean handleDeathLoot(DamageSource cause, Collection<ItemEntity> drops) {
        if (this.handlers.values().stream().filter(e -> e.handleDeathLoot(cause, drops)).findAny().isPresent()) {
            return true;
        }
        if (!this.keepInventory()) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                ItemStack itemStack = this.itemHandler.extractItem(i, Integer.MAX_VALUE, false);
                if (itemStack.func_190926_b()) continue;
                ItemEntity itemEntity = new ItemEntity(this.getLevel(), this.getEntity().func_226277_ct_(), this.getEntity().func_226278_cu_(), this.getEntity().func_226281_cx_(), itemStack);
                itemEntity.func_174869_p();
                drops.add(itemEntity);
            }
        }
        return false;
    }

    protected boolean keepInventory() {
        return false;
    }

    @Override
    public Visibility getVisibility() {
        return this.cachedVisibility;
    }

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public EntitySnapshot getSnapshot(int tick) {
        int currentTick = this.entity.func_184102_h().func_71259_af();
        if (tick >= currentTick) {
            return new EntitySnapshot((Entity)this.entity);
        }
        if (tick < currentTick - 20) {
            return this.snapshots[0];
        }
        int snapshotIndex = tick % 20;
        EntitySnapshot snapshot = this.snapshots[snapshotIndex];
        if (snapshot == null) {
            throw new IndexOutOfBoundsException();
        }
        return snapshot;
    }

    @Override
    public boolean isCrouching() {
        return this.crouching;
    }

    @Override
    public void setCrouching(boolean crouching, boolean sendUpdate) {
        if (!this.entity.func_233570_aj_()) {
            return;
        }
        this.crouching = crouching;
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = this.getLevel().func_201670_d() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY_AND_SELF.with(this::getEntity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new CrouchMessage(this.getEntity().func_145782_y(), crouching));
        }
    }

    @Override
    public E getEntity() {
        return this.entity;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("inventory", (INBT)this.itemHandler.serializeNBT());
        for (Map.Entry<ResourceLocation, H> entry : this.handlers.entrySet()) {
            CompoundNBT extensionNbt = ((LivingHandler)entry.getValue()).serializeNBT();
            if (extensionNbt.isEmpty()) continue;
            nbt.func_218657_a(entry.getKey().toString(), (INBT)extensionNbt);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.itemHandler.deserializeNBT(nbt.func_74775_l("inventory"));
        for (Map.Entry<ResourceLocation, H> entry : this.handlers.entrySet()) {
            CompoundNBT extensionNbt = nbt.func_74775_l(entry.getKey().toString());
            if (extensionNbt.isEmpty()) continue;
            ((LivingHandler)entry.getValue()).deserializeNBT(extensionNbt);
        }
    }

    public int hashCode() {
        return this.entity.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj) || obj instanceof LivingExtension && ((LivingExtension)obj).getEntity().equals(this.entity);
    }

    @Override
    public void encode(PacketBuffer out, boolean writeAll) {
        if (writeAll) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                out.writeShort(i);
                out.func_150788_a(this.itemHandler.getStackInSlot(i));
            }
        } else {
            for (int i : this.dirtySlots) {
                out.writeShort(i);
                out.func_150788_a(this.itemHandler.getStackInSlot(i));
            }
            this.dirtySlots.clear();
        }
        out.writeShort(255);
        Set<Map.Entry<ResourceLocation, H>> handlersToSend = writeAll ? this.handlers.entrySet() : this.dirtyHandlers.entrySet();
        out.func_150787_b(handlersToSend.size());
        for (Map.Entry<ResourceLocation, H> entry : handlersToSend) {
            out.func_192572_a(entry.getKey());
            PacketBuffer handlerData = new PacketBuffer(Unpooled.buffer());
            ((LivingHandler)entry.getValue()).encode(handlerData, writeAll);
            out.func_150787_b(handlerData.readableBytes());
            out.writeBytes((ByteBuf)handlerData);
        }
        this.dirtyHandlers.clear();
    }

    @Override
    public void decode(PacketBuffer in) {
        short slot;
        while ((slot = in.readShort()) != 255) {
            this.itemHandler.setStackInSlot((int)slot, in.func_150791_c());
        }
        int handlersSize = in.func_150792_a();
        for (int x = 0; x < handlersSize; ++x) {
            ResourceLocation id = in.func_192575_l();
            int dataSize = in.func_150792_a();
            LivingHandler handler = (LivingHandler)this.handlers.get(id);
            if (handler == null) {
                in.readerIndex(in.readerIndex() + dataSize);
                continue;
            }
            handler.decode(in);
        }
    }

    @Override
    public boolean requiresSync() {
        return !this.dirtySlots.isEmpty() || !this.dirtyHandlers.isEmpty();
    }
}

