/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action.reload;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.client.animation.AnimationType;
import com.craftingdead.core.client.animation.GunAnimation;
import com.craftingdead.core.client.animation.reload.GunAnimationReload;
import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.action.TimedAction;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.gun.Gun;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;

public abstract class AbstractReloadAction
extends TimedAction<ActionType> {
    protected final ItemStack gunStack;
    protected final Gun gun;
    protected final ItemStack oldMagazineStack;

    public AbstractReloadAction(ActionType type, LivingExtension<?, ?> performer, @Nullable LivingExtension<?, ?> target) {
        super(type, performer, target);
        this.gunStack = performer.getMainHandItem();
        this.gun = (Gun)this.gunStack.getCapability(Capabilities.GUN).orElseThrow(() -> new IllegalStateException("Performer not holding gun"));
        this.oldMagazineStack = this.gun.getAmmoProvider().getMagazineStack();
    }

    @Override
    protected int getTotalDurationTicks() {
        return this.gun.getReloadDurationTicks();
    }

    @Override
    public boolean start() {
        if (this.getPerformer().getEntity().func_70051_ag()) {
            return false;
        }
        if (this.gun.isPerformingSecondaryAction()) {
            this.gun.setPerformingSecondaryAction(this.getPerformer(), false, false);
        }
        this.gun.getReloadSound().ifPresent(sound -> this.getPerformer().getLevel().func_217384_a(null, this.getPerformer().getEntity(), sound, SoundCategory.PLAYERS, 1.0f, 1.0f));
        if (this.getPerformer().getLevel().func_201670_d()) {
            if (this.oldMagazineStack.func_190926_b()) {
                this.playLoadAnimation(false, null);
            } else {
                this.playLoadAnimation(true, () -> this.playLoadAnimation(false, null));
            }
        }
        return true;
    }

    protected abstract void loadNewMagazineStack(boolean var1);

    private void playLoadAnimation(boolean unload, @Nullable Runnable callback) {
        if (!unload) {
            this.loadNewMagazineStack(true);
        }
        this.gun.getClient().getAnimation(AnimationType.RELOAD).filter(animation -> animation instanceof GunAnimationReload).map(animation -> (GunAnimationReload)animation).ifPresent(animation -> {
            animation.setEjectingClip(unload);
            this.gun.getClient().getAnimationController().addAnimation((GunAnimation)animation, callback);
        });
    }

    @Override
    public boolean tick() {
        if (!this.getPerformer().getLevel().func_201670_d() && this.getPerformer().getEntity().func_70051_ag()) {
            this.getPerformer().cancelAction(true);
            return false;
        }
        return super.tick();
    }

    @Override
    protected void finish() {
        if (this.getPerformer().getLevel().func_201670_d()) {
            return;
        }
        this.loadNewMagazineStack(false);
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.getPerformer().getLevel().func_201670_d()) {
            if (this.gun.getReloadSound().isPresent()) {
                Minecraft.func_71410_x().func_147118_V().func_195478_a(this.gun.getReloadSound().get().getRegistryName(), SoundCategory.PLAYERS);
            }
            this.gun.getClient().getAnimationController().removeCurrentAnimation();
        }
        this.revert();
    }

    protected abstract void revert();
}

