/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action.item;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.client.ClientDist;
import com.craftingdead.core.world.action.TimedAction;
import com.craftingdead.core.world.action.delegated.DelegatedAction;
import com.craftingdead.core.world.action.delegated.DelegatedActionType;
import com.craftingdead.core.world.action.item.ItemActionType;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;

public class ItemAction
extends TimedAction<ItemActionType> {
    private DelegatedAction delegatedAction;

    ItemAction(ItemActionType type, LivingExtension<?, ?> performer, LivingExtension<?, ?> target) {
        super(type, performer, target);
    }

    @Override
    public boolean start() {
        ItemStack heldStack = this.getPerformer().getMainHandItem();
        if (((ItemActionType)((Object)this.getType())).getHeldItemPredicate().test(heldStack)) {
            for (DelegatedActionType delegatedActionType : ((ItemActionType)((Object)this.getType())).getDelegatedActionTypes()) {
                DelegatedAction action = delegatedActionType.create(this).orElse(null);
                if (action == null) continue;
                this.delegatedAction = action;
                return super.start();
            }
        }
        return false;
    }

    @Override
    protected final void finish() {
        ItemStack heldStack = this.getPerformer().getMainHandItem();
        if (this.delegatedAction.finish(this.getPerformer(), this.getTarget().orElse(null), heldStack)) {
            PlayerEntity playerEntity;
            boolean shrinkStack = this.delegatedAction.shouldShrinkStack(this.getPerformer());
            ItemStack resultStack = this.delegatedAction.getReturnItem(this.getPerformer()).map(Item::func_190903_i).orElse(ItemStack.field_190927_a);
            PlayerEntity playerEntity2 = playerEntity = this.getPerformer().getEntity() instanceof PlayerEntity ? (PlayerEntity)this.getPerformer().getEntity() : null;
            if (shrinkStack && (playerEntity == null || !playerEntity.func_184812_l_())) {
                heldStack.func_190918_g(1);
            }
            if (!resultStack.func_190926_b()) {
                if (heldStack.func_190926_b()) {
                    this.getPerformer().getEntity().func_184611_a(Hand.MAIN_HAND, resultStack);
                } else if (playerEntity != null && playerEntity.field_71071_by.func_70441_a(resultStack)) {
                    this.getPerformer().getEntity().func_199701_a_(resultStack);
                }
            }
            this.delegatedAction.getFinishSound().ifPresent(sound -> this.getPerformer().getEntity().func_184185_a(sound, 1.0f, 1.0f));
        }
    }

    @Override
    public boolean tick() {
        boolean finished = super.tick();
        ItemStack heldStack = this.getPerformer().getMainHandItem();
        boolean usingItem = true;
        if (this.getPerformer().getLevel().func_201670_d()) {
            ClientDist clientDist = CraftingDead.getInstance().getClientDist();
            boolean bl = usingItem = !clientDist.isLocalPlayer((Entity)this.getPerformer().getEntity()) || clientDist.isRightMouseDown();
        }
        if (!this.delegatedAction.canPerform(this.getPerformer(), this.getTarget().orElse(null), heldStack) || !usingItem) {
            this.getPerformer().cancelAction(true);
        }
        if (((ItemActionType)((Object)this.getType())).isFreezeMovement()) {
            this.getTarget().ifPresent(target -> target.setMovementBlocked(true));
            this.getPerformer().setMovementBlocked(true);
        }
        return finished;
    }

    @Override
    protected int getTotalDurationTicks() {
        return ((ItemActionType)((Object)this.getType())).getTotalDurationTicks();
    }
}

