/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action.delegated;

import com.craftingdead.core.world.action.delegated.AbstractDelegatedAction;
import com.craftingdead.core.world.action.delegated.DelegatedBlockActionType;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.ForgeMod;

public final class DelegatedBlockAction
extends AbstractDelegatedAction<DelegatedBlockActionType> {
    private BlockPos blockPosTarget;
    private BlockState blockStateTarget;

    DelegatedBlockAction(DelegatedBlockActionType type) {
        super(type);
    }

    @Override
    public boolean canPerform(LivingExtension<?, ?> performer, @Nullable LivingExtension<?, ?> target, ItemStack heldStack) {
        ModifiableAttributeInstance reachDistanceAttribute = performer.getEntity().func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get());
        RayTraceResult result = performer.getEntity().func_213324_a(reachDistanceAttribute == null ? 4.0 : reachDistanceAttribute.func_111126_e(), 1.0f, true);
        if (result instanceof BlockRayTraceResult) {
            BlockPos blockPos = ((BlockRayTraceResult)result).func_216350_a();
            BlockState blockState = performer.getLevel().func_180495_p(blockPos);
            if (this.blockPosTarget == null || this.blockStateTarget == null) {
                this.blockPosTarget = blockPos;
                this.blockStateTarget = blockState;
                if (!((DelegatedBlockActionType)this.type).getPredicate().test(this.blockStateTarget)) {
                    return false;
                }
            }
            return this.blockPosTarget.equals((Object)blockPos) && this.blockStateTarget.equals(blockState);
        }
        return false;
    }

    @Override
    public boolean finish(LivingExtension<?, ?> performer, LivingExtension<?, ?> target, ItemStack heldStack) {
        return true;
    }
}

