/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action;

import com.craftingdead.core.world.entity.extension.LivingExtension;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;

@FunctionalInterface
public interface TargetSelector {
    public static final TargetSelector SELF_ONLY = (performer, target) -> Optional.of(performer);
    public static final TargetSelector OTHERS_ONLY = (performer, target) -> Optional.ofNullable(target);
    public static final TargetSelector SELF_OR_OTHERS = (performer, target) -> Optional.ofNullable(target == null ? performer : target);

    public Optional<LivingExtension<?, ?>> select(LivingExtension<?, ?> var1, @Nullable LivingExtension<?, ?> var2);

    default public TargetSelector ofType(EntityType<?> entityType) {
        return this.andThen(target -> Optional.ofNullable(target.getEntity().func_200600_R() == entityType ? target : null));
    }

    default public TargetSelector ofType(Class<? extends LivingEntity> entityType) {
        return this.andThen(target -> Optional.ofNullable(target != null && entityType.isInstance(target.getEntity()) ? target : null));
    }

    default public TargetSelector andThen(Function<LivingExtension<?, ?>, Optional<LivingExtension<?, ?>>> after) {
        Objects.requireNonNull(after);
        return (performer, target) -> (Optional)after.apply(this.select(performer, target).orElse(null));
    }
}

