/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action;

import com.craftingdead.core.client.animation.AnimationType;
import com.craftingdead.core.client.animation.GunAnimation;
import com.craftingdead.core.client.animation.reload.GunAnimationReload;
import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.action.TimedAction;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.gun.Gun;
import com.craftingdead.core.world.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.gun.ammoprovider.MagazineAmmoProvider;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;

public class RemoveMagazineAction
extends TimedAction<ActionType> {
    private final Gun gun;
    private final ItemStack oldMagazineStack;
    private final MagazineAmmoProvider ammoProvider;

    public RemoveMagazineAction(ActionType type, LivingExtension<?, ?> performer, @Nullable LivingExtension<?, ?> target) {
        super(type, performer, target);
        this.gun = (Gun)performer.getMainHandGun().orElseThrow(() -> new IllegalStateException("Performer not holding gun"));
        AmmoProvider ammoProvider = this.gun.getAmmoProvider();
        if (!(ammoProvider instanceof MagazineAmmoProvider)) {
            throw new IllegalStateException("No MagazineAmmoProvider present");
        }
        this.ammoProvider = (MagazineAmmoProvider)ammoProvider;
        this.oldMagazineStack = this.ammoProvider.getMagazineStack();
    }

    @Override
    protected int getTotalDurationTicks() {
        return this.gun.getReloadDurationTicks() / 2;
    }

    @Override
    public boolean start() {
        if (!this.getPerformer().getEntity().func_70051_ag() && !this.oldMagazineStack.func_190926_b()) {
            if (this.gun.isPerformingSecondaryAction()) {
                this.gun.setPerformingSecondaryAction(this.getPerformer(), false, false);
            }
            if (this.getPerformer().getLevel().func_201670_d()) {
                this.gun.getClient().getAnimation(AnimationType.RELOAD).filter(animation -> animation instanceof GunAnimationReload).map(animation -> (GunAnimationReload)animation).ifPresent(animation -> {
                    animation.setEjectingClip(true);
                    this.gun.getClient().getAnimationController().addAnimation((GunAnimation)animation, () -> this.ammoProvider.setMagazineStack(ItemStack.field_190927_a));
                });
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean tick() {
        if (this.getPerformer().getEntity().func_70051_ag()) {
            this.getPerformer().cancelAction(false);
            return false;
        }
        return super.tick();
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.getPerformer().getLevel().func_201670_d()) {
            this.gun.getClient().getAnimationController().removeCurrentAnimation();
        }
        this.ammoProvider.setMagazineStack(this.oldMagazineStack);
    }

    @Override
    protected void finish() {
        if (!this.getPerformer().getLevel().func_201670_d()) {
            this.ammoProvider.setMagazineStack(ItemStack.field_190927_a);
            if (!this.oldMagazineStack.func_190926_b() && this.getPerformer().getEntity() instanceof PlayerEntity) {
                ((PlayerEntity)this.getPerformer().getEntity()).func_191521_c(this.oldMagazineStack);
            }
        }
    }
}

