/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action;

import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.action.RemoveMagazineAction;
import com.craftingdead.core.world.action.TargetSelector;
import com.craftingdead.core.world.action.delegated.DelegatedEntityActionType;
import com.craftingdead.core.world.action.item.ItemActionType;
import com.craftingdead.core.world.action.reload.MagazineReloadAction;
import com.craftingdead.core.world.action.reload.RefillableReloadAction;
import com.craftingdead.core.world.effect.ModMobEffects;
import com.craftingdead.core.world.item.ModItems;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;

public class ActionTypes {
    public static final DeferredRegister<ActionType> ACTION_TYPES = DeferredRegister.create(ActionType.class, (String)"craftingdead");
    public static final Lazy<IForgeRegistry<ActionType>> REGISTRY = Lazy.of((Supplier)ACTION_TYPES.makeRegistry("action_types", RegistryBuilder::new));
    public static final RegistryObject<ActionType> MAGAZINE_RELOAD = ACTION_TYPES.register("magazine_reload", () -> new ActionType(true, MagazineReloadAction::new));
    public static final RegistryObject<ActionType> REFILLABLE_RELOAD = ACTION_TYPES.register("refillable_reload", () -> new ActionType(true, RefillableReloadAction::new));
    public static final RegistryObject<ActionType> REMOVE_MAGAZINE = ACTION_TYPES.register("remove_magazine", () -> new ActionType(true, RemoveMagazineAction::new));
    public static final RegistryObject<ActionType> USE_SYRINGE = ACTION_TYPES.register("use_syringe", () -> ItemActionType.builder().setHeldItemPredicate(itemStack -> itemStack.func_77973_b() == ModItems.SYRINGE.get()).setTotalDurationTicks(16).addDelegatedAction(((DelegatedEntityActionType.Builder)DelegatedEntityActionType.builder().setTargetSelector((performer, target) -> {
        if (target == null || performer == target || target.getEntity() instanceof SkeletonEntity) {
            return Optional.empty();
        }
        Object targetEntity = target.getEntity();
        if (targetEntity.func_110143_aJ() > 4.0f) {
            return Optional.ofNullable(target);
        }
        if (performer.getEntity() instanceof PlayerEntity) {
            ((PlayerEntity)performer.getEntity()).func_146105_b((ITextComponent)new TranslationTextComponent("message.low_health", new Object[]{targetEntity.func_145748_c_()}).func_240699_a_(TextFormatting.RED), true);
        }
        return Optional.empty();
    }).setCustomAction(extension -> extension.getEntity().func_70097_a(DamageSource.func_76358_a(extension.getEntity()), 2.0f), Float.valueOf(1.0f)).setReturnItem((Supplier<Item>)ModItems.BLOOD_SYRINGE)).build()).build());
    public static final RegistryObject<ActionType> USE_FIRST_AID_KIT = ACTION_TYPES.register("use_first_aid_kit", () -> ItemActionType.builder().setHeldItemPredicate(itemStack -> itemStack.func_77973_b() == ModItems.FIRST_AID_KIT.get()).setFreezeMovement(true).addDelegatedAction(DelegatedEntityActionType.builder().setTargetSelector(TargetSelector.SELF_OR_OTHERS).addEffect(() -> new EffectInstance(Effects.field_76432_h, 1, 1), Float.valueOf(1.0f)).build()).build());
    public static final RegistryObject<ActionType> USE_ADRENALINE_SYRINGE = ACTION_TYPES.register("use_adrenaline_syringe", () -> ItemActionType.builder().setHeldItemPredicate(itemStack -> itemStack.func_77973_b() == ModItems.ADRENALINE_SYRINGE.get()).setTotalDurationTicks(16).addDelegatedAction(((DelegatedEntityActionType.Builder)((DelegatedEntityActionType.Builder)DelegatedEntityActionType.builder().setTargetSelector(TargetSelector.SELF_OR_OTHERS).setReturnItem((Supplier<Item>)ModItems.SYRINGE)).setReturnItemInCreative(false)).addEffect(() -> new EffectInstance((Effect)ModMobEffects.ADRENALINE.get(), 400, 1), Float.valueOf(1.0f)).build()).build());
    public static final RegistryObject<ActionType> USE_BLOOD_SYRINGE = ACTION_TYPES.register("use_blood_syringe", () -> ItemActionType.builder().setHeldItemPredicate(itemStack -> itemStack.func_77973_b() == ModItems.BLOOD_SYRINGE.get()).setTotalDurationTicks(16).addDelegatedAction(((DelegatedEntityActionType.Builder)((DelegatedEntityActionType.Builder)DelegatedEntityActionType.builder().setTargetSelector(TargetSelector.SELF_OR_OTHERS).setReturnItem((Supplier<Item>)ModItems.SYRINGE)).setReturnItemInCreative(false)).addEffect(() -> new EffectInstance(Effects.field_76432_h, 1, 0), Float.valueOf(1.0f)).build()).build());
    public static final RegistryObject<ActionType> USE_BANDAGE = ACTION_TYPES.register("use_bandage", () -> ItemActionType.builder().setHeldItemPredicate(itemStack -> itemStack.func_77973_b() == ModItems.BANDAGE.get()).setTotalDurationTicks(16).addDelegatedAction(DelegatedEntityActionType.builder().setTargetSelector(TargetSelector.SELF_OR_OTHERS).addEffect(() -> new EffectInstance(Effects.field_76432_h, 1, 0), Float.valueOf(1.0f)).build()).build());
}

