/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.particle;

import com.craftingdead.core.particle.ModParticleTypes;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;

public class RGBFlashParticleData
implements IParticleData {
    public static final Codec<RGBFlashParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("red").forGetter(RGBFlashParticleData::getRed), (App)Codec.FLOAT.fieldOf("green").forGetter(RGBFlashParticleData::getGreen), (App)Codec.FLOAT.fieldOf("blue").forGetter(RGBFlashParticleData::getBlue), (App)Codec.FLOAT.fieldOf("scale").forGetter(RGBFlashParticleData::getScale)).apply((Applicative)instance, RGBFlashParticleData::new));
    public static final IParticleData.IDeserializer<RGBFlashParticleData> DESERIALIZER = new IParticleData.IDeserializer<RGBFlashParticleData>(){

        public RGBFlashParticleData fromCommand(ParticleType<RGBFlashParticleData> particleType, StringReader stringReader) throws CommandSyntaxException {
            stringReader.expect(' ');
            float red = stringReader.readFloat();
            stringReader.expect(' ');
            float green = stringReader.readFloat();
            stringReader.expect(' ');
            float blue = stringReader.readFloat();
            stringReader.expect(' ');
            float scale = stringReader.readFloat();
            return new RGBFlashParticleData(red, green, blue, scale);
        }

        public RGBFlashParticleData fromNetwork(ParticleType<RGBFlashParticleData> particleType, PacketBuffer packetBuffer) {
            return new RGBFlashParticleData(packetBuffer.readFloat(), packetBuffer.readFloat(), packetBuffer.readFloat(), packetBuffer.readFloat());
        }
    };
    private final float red;
    private final float green;
    private final float blue;
    private final float scale;

    public RGBFlashParticleData(float red, float green, float blue, float scale) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.scale = scale;
    }

    public void func_197553_a(PacketBuffer packetBuffer) {
        packetBuffer.writeFloat(this.red);
        packetBuffer.writeFloat(this.green);
        packetBuffer.writeFloat(this.blue);
        packetBuffer.writeFloat(this.scale);
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f", this.func_197554_b().getRegistryName(), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.scale));
    }

    public ParticleType<RGBFlashParticleData> func_197554_b() {
        return (ParticleType)ModParticleTypes.RGB_FLASH.get();
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getScale() {
        return this.scale;
    }
}

