/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.world.entity.extension.EntitySnapshot;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.gun.PendingHit;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ValidatePendingHitMessage {
    private final Map<Integer, Collection<PendingHit>> hits;

    public ValidatePendingHitMessage(Map<Integer, Collection<PendingHit>> hits) {
        this.hits = hits;
    }

    public void encode(PacketBuffer out) {
        out.func_150787_b(this.hits.size());
        for (Map.Entry<Integer, Collection<PendingHit>> hit : this.hits.entrySet()) {
            out.func_150787_b(hit.getKey().intValue());
            out.func_150787_b(hit.getValue().size());
            for (PendingHit value : hit.getValue()) {
                out.writeByte((int)value.getTickOffset());
                value.getPlayerSnapshot().write(out);
                value.getHitSnapshot().write(out);
                out.func_179254_b(value.getRandomSeed());
            }
        }
    }

    public static ValidatePendingHitMessage decode(PacketBuffer in) {
        int hitsSize = in.func_150792_a();
        Int2ObjectLinkedOpenHashMap hits = new Int2ObjectLinkedOpenHashMap();
        for (int i = 0; i < hitsSize; ++i) {
            int key = in.func_150792_a();
            int valueSize = in.func_150792_a();
            ObjectArrayList value = new ObjectArrayList();
            for (int j = 0; j < valueSize; ++j) {
                value.add(new PendingHit(in.readByte(), EntitySnapshot.read(in), EntitySnapshot.read(in), in.func_179260_f()));
            }
            hits.put(key, value);
        }
        return new ValidatePendingHitMessage((Map<Integer, Collection<PendingHit>>)hits);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            PlayerExtension<ServerPlayerEntity> extension = PlayerExtension.getOrThrow(player);
            extension.getMainHandGun().ifPresent(gun -> {
                for (Map.Entry<Integer, Collection<PendingHit>> hit : this.hits.entrySet()) {
                    Optional.ofNullable(player.field_70170_p.func_73045_a(hit.getKey().intValue())).flatMap(entity -> entity.getCapability(Capabilities.LIVING_EXTENSION).resolve()).ifPresent(hitLiving -> {
                        for (PendingHit value : (Collection)hit.getValue()) {
                            gun.validatePendingHit(extension, (LivingExtension<?, ?>)hitLiving, value);
                        }
                    });
                }
            });
        });
        return true;
    }
}

