/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.network.NetworkUtil;
import com.craftingdead.core.world.gun.Gun;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncGunContainerSlotMessage {
    private final int entityId;
    private final int slot;
    private final PacketBuffer data;

    public SyncGunContainerSlotMessage(int entityId, int slot, Gun gun, boolean writeAll) {
        this(entityId, slot, new PacketBuffer(Unpooled.buffer()));
        gun.encode(this.data, writeAll);
    }

    public SyncGunContainerSlotMessage(int entityId, int slot, PacketBuffer data) {
        this.entityId = entityId;
        this.slot = slot;
        this.data = data;
    }

    public void encode(PacketBuffer out) {
        out.func_150787_b(this.entityId);
        out.writeShort(this.slot);
        out.func_150787_b(this.data.readableBytes());
        out.writeBytes((ByteBuf)this.data);
    }

    public static SyncGunContainerSlotMessage decode(PacketBuffer in) {
        int entityId = in.func_150792_a();
        short slot = in.readShort();
        byte[] data = new byte[in.func_150792_a()];
        in.readBytes(data);
        return new SyncGunContainerSlotMessage(entityId, slot, new PacketBuffer(Unpooled.wrappedBuffer((byte[])data)));
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> NetworkUtil.getEntity((NetworkEvent.Context)((NetworkEvent.Context)ctx.get()), (int)this.entityId, PlayerEntity.class).field_71069_bz.func_75139_a(this.slot).func_75211_c().getCapability(Capabilities.GUN).ifPresent(gun -> gun.decode(this.data)));
        return true;
    }
}

