/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.mixin;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.world.gun.Gun;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PacketBuffer.class})
public class PacketBufferMixin {
    @Inject(at={@At(value="RETURN")}, method={"Lnet/minecraft/network/PacketBuffer;writeItemStack(Lnet/minecraft/item/ItemStack;Z)Lnet/minecraft/network/PacketBuffer;"}, remap=false)
    private void writeItemStack(ItemStack itemStack, boolean limitedTag, CallbackInfoReturnable<PacketBuffer> callbackInfo) {
        PacketBuffer packetBuffer = (PacketBuffer)this;
        Gun gun = (Gun)itemStack.getCapability(Capabilities.GUN).orElse(null);
        if (gun == null) {
            packetBuffer.func_150787_b(0);
        } else {
            PacketBuffer data = new PacketBuffer(Unpooled.buffer());
            gun.encode(data, true);
            packetBuffer.func_150787_b(data.readableBytes());
            packetBuffer.writeBytes((ByteBuf)data);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"readItem"})
    private void readItem(CallbackInfoReturnable<ItemStack> callbackInfo) {
        PacketBuffer packetBuffer = (PacketBuffer)this;
        ItemStack itemStack = (ItemStack)callbackInfo.getReturnValue();
        byte[] data = new byte[packetBuffer.func_150792_a()];
        if (data.length > 0) {
            packetBuffer.readBytes(data);
            Gun gun = (Gun)itemStack.getCapability(Capabilities.GUN).orElse(null);
            if (gun != null) {
                gun.decode(new PacketBuffer(Unpooled.wrappedBuffer((byte[])data)));
            }
        }
    }
}

