/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.mixin;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.world.entity.extension.Visibility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Inject(method={"isInvisible"}, at={@At(value="HEAD")}, cancellable=true)
    private void isInvisible(CallbackInfoReturnable<Boolean> callbackInfo) {
        Entity entity = (Entity)this;
        entity.getCapability(Capabilities.LIVING_EXTENSION).ifPresent(living -> {
            if (living.getVisibility() == Visibility.INVISIBLE || living.getVisibility() == Visibility.PARTIALLY_VISIBLE) {
                callbackInfo.setReturnValue((Object)true);
            }
        });
    }

    @Inject(method={"isInvisibleTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void isInvisibleTo(PlayerEntity playerEntity, CallbackInfoReturnable<Boolean> callbackInfo) {
        Entity entity = (Entity)this;
        entity.getCapability(Capabilities.LIVING_EXTENSION).ifPresent(living -> {
            if (living.getVisibility() == Visibility.PARTIALLY_VISIBLE) {
                callbackInfo.setReturnValue((Object)false);
            }
        });
    }
}

