/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.data;

import com.craftingdead.core.world.item.crafting.ModRecipeSerializers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class UpgradeMagazineRecipeBuilder {
    private final Ingredient magazine;
    private final Item nextTier;
    private final Advancement.Builder advancement = Advancement.Builder.func_200278_a();
    private String group;

    private UpgradeMagazineRecipeBuilder(Ingredient magazine, Item nextTier) {
        this.magazine = magazine;
        this.nextTier = nextTier;
    }

    public static UpgradeMagazineRecipeBuilder create(Ingredient magazine, Item nextTier) {
        return new UpgradeMagazineRecipeBuilder(magazine, nextTier);
    }

    public UpgradeMagazineRecipeBuilder unlockedBy(String id, ICriterionInstance criterion) {
        this.advancement.func_200275_a(id, criterion);
        return this;
    }

    public UpgradeMagazineRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public void save(Consumer<IFinishedRecipe> consumer) {
        this.save(consumer, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.nextTier));
    }

    public void save(Consumer<IFinishedRecipe> consumer, String id) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.nextTier);
        if (new ResourceLocation(id).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shapeless Recipe " + id + " should remove its 'save' argument");
        }
        this.save(consumer, new ResourceLocation(id));
    }

    public void save(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumer.accept(new Result(id, this.nextTier, this.group == null ? "" : this.group, this.magazine, this.advancement, new ResourceLocation(id.func_110624_b(), "recipes/" + this.nextTier.func_77640_w().func_200300_c() + "/" + id.func_110623_a())));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item nextTier;
        private final String group;
        private final Ingredient magazine;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, Item nextTier, String group, Ingredient magazine, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.nextTier = nextTier;
            this.group = group;
            this.magazine = magazine;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("magazine", this.magazine.func_200304_c());
            JsonObject nextTierJson = new JsonObject();
            nextTierJson.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.nextTier).toString());
            json.add("nextTier", (JsonElement)nextTierJson);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)ModRecipeSerializers.UPGRADE_MAGAZINE.get();
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancement.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

