/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer.item;

import com.craftingdead.core.client.renderer.item.GunRenderer;
import com.craftingdead.core.client.renderer.item.model.ModelScarhIS2;
import com.craftingdead.core.world.gun.Gun;
import com.craftingdead.core.world.gun.attachment.Attachment;
import com.craftingdead.core.world.gun.attachment.Attachments;
import com.craftingdead.core.world.gun.type.GunTypes;
import com.craftingdead.core.world.item.ModItems;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class MossbergRenderer
extends GunRenderer {
    private final Model ironSight = new ModelScarhIS2();

    public MossbergRenderer() {
        super(ModItems.MOSSBERG.getId(), GunTypes.MOSSBERG);
    }

    @Override
    protected void applyGenericTransforms(Gun gun, MatrixStack matrixStack) {
        matrixStack.func_227862_a_(1.5f, 1.5f, 1.5f);
        matrixStack.func_227861_a_(-0.7, -0.1, 0.0);
    }

    @Override
    protected void applyThirdPersonTransforms(Gun gun, MatrixStack matrixStack) {
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-15.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(77.0f));
        matrixStack.func_227861_a_((double)0.2f, (double)-0.7f, (double)0.4f);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(15.0f));
        matrixStack.func_227861_a_((double)-0.2f, (double)0.55f, 0.0);
        float scale = 1.2f;
        matrixStack.func_227862_a_(scale, scale, scale);
    }

    @Override
    protected void applyFirstPersonTransforms(Gun gun, MatrixStack matrixStack) {
        this.muzzleFlashX = 0.5f;
        this.muzzleFlashY = -0.13f;
        this.muzzleFlashZ = -2.5f;
        this.muzzleScale = 2.0f;
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-40.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-3.0f));
        matrixStack.func_227861_a_((double)0.4f, (double)-0.15f, (double)0.17f);
        float scale = 1.0f;
        matrixStack.func_227862_a_(scale, scale, scale);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(3.0f));
    }

    @Override
    protected void applyAimingTransforms(Gun gun, MatrixStack matrixStack) {
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-24.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(5.1f));
        matrixStack.func_227861_a_(-0.0, (double)-0.64f, (double)0.972f);
        if (!gun.hasIronSight()) {
            matrixStack.func_227861_a_(0.0, (double)0.017f, 0.0);
        }
        float scale = 0.6f;
        matrixStack.func_227862_a_(scale, scale, scale);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-0.7f));
        matrixStack.func_227861_a_(0.0, 0.0, 0.0);
    }

    @Override
    protected void renderAdditionalParts(Gun gun, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, int packedOverlay) {
        this.renderIronSight(matrixStack, renderTypeBuffer, packedLight, packedOverlay);
    }

    private void renderIronSight(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, int packedOverlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)1.4f, (double)-0.185f, (double)0.0315f);
        float scale = 0.49f;
        matrixStack.func_227862_a_(scale, scale, scale);
        IVertexBuilder vertexBuilder = renderTypeBuffer.getBuffer(this.ironSight.func_228282_a_(new ResourceLocation("craftingdead", "textures/attachment/scarh_is2.png")));
        this.ironSight.func_225598_a_(matrixStack, vertexBuilder, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    @Override
    protected void applyWearingTransforms(Gun gun, MatrixStack matrixStack) {
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        float scale = 0.7f;
        matrixStack.func_227862_a_(scale, scale, scale);
        matrixStack.func_227861_a_((double)-0.9f, (double)0.32f, (double)0.23f);
    }

    @Override
    protected void applyMagazineTransforms(ItemStack itemStack, MatrixStack matrixStack) {
    }

    @Override
    protected void applyAttachmentTransforms(Attachment attachment, MatrixStack matrixStack) {
        if (attachment == Attachments.TACTICAL_GRIP.get()) {
            matrixStack.func_227861_a_(9.0, 1.0, 1.0);
            float scale = 0.6f;
            matrixStack.func_227862_a_(scale, scale, scale);
            return;
        }
    }

    @Override
    protected void applyHandTransforms(Gun gun, boolean rightHand, MatrixStack matrixStack) {
        if (rightHand) {
            matrixStack.func_227861_a_((double)-0.1f, (double)-0.15f, (double)-0.3f);
        } else {
            matrixStack.func_227861_a_((double)0.01f, (double)0.15f, (double)-0.1f);
        }
    }

    @Override
    protected void applySprintingTransforms(MatrixStack matrixStack, float pct) {
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(pct * -50.0f));
        matrixStack.func_227861_a_((double)(pct * 0.5f), 0.0, (double)(pct * 0.1f));
    }
}

