/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer.entity.layers;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.client.util.RenderUtil;
import com.craftingdead.core.world.inventory.ModEquipmentSlotType;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.TransformationMatrix;
import org.apache.commons.lang3.Validate;

public class EquipmentLayer<T extends LivingEntity, M extends BipedModel<T>>
extends LayerRenderer<T, M> {
    private final ModEquipmentSlotType slot;
    private final boolean useCrouchingOrientation;
    private final boolean useHeadOrientation;
    private final TransformationMatrix transformation;

    private EquipmentLayer(Builder<T, M> builder) {
        super((IEntityRenderer)((Builder)builder).entityRenderer);
        this.slot = ((Builder)builder).slot;
        this.useCrouchingOrientation = ((Builder)builder).useCrouchingOrientation;
        this.transformation = ((Builder)builder).tranformation;
        this.useHeadOrientation = ((Builder)builder).useHeadOrientation;
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageTicks, float headYaw, float headPitch) {
        boolean partiallyVisible;
        Minecraft minecraft = Minecraft.func_71410_x();
        boolean invisible = livingEntity.func_82150_aj();
        boolean bl = partiallyVisible = livingEntity.func_82150_aj() && !livingEntity.func_98034_c((PlayerEntity)minecraft.field_71439_g);
        if (partiallyVisible || !invisible) {
            ItemRenderer itemRenderer = minecraft.func_175599_af();
            livingEntity.getCapability(Capabilities.LIVING_EXTENSION).ifPresent(living -> {
                ItemStack itemStack = living.getItemHandler().getStackInSlot(this.slot.getIndex());
                if (!itemStack.func_190926_b()) {
                    IBakedModel bakedModel = itemRenderer.func_184393_a(itemStack, livingEntity.field_70170_p, livingEntity);
                    matrixStack.func_227860_a_();
                    if (this.useCrouchingOrientation && livingEntity.func_213453_ef()) {
                        RenderUtil.applyPlayerCrouchRotation(matrixStack);
                    }
                    if (this.useHeadOrientation) {
                        if (livingEntity.func_70631_g_()) {
                            matrixStack.func_227861_a_(0.0, 0.03125, 0.0);
                            matrixStack.func_227862_a_(0.7f, 0.7f, 0.7f);
                            matrixStack.func_227861_a_(0.0, 1.0, 0.0);
                        }
                        ((BipedModel)this.func_215332_c()).func_205072_a().func_228307_a_(matrixStack);
                    }
                    if (this.transformation != null) {
                        this.transformation.push(matrixStack);
                    }
                    itemRenderer.func_229111_a_(itemStack, ItemCameraTransforms.TransformType.HEAD, false, matrixStack, renderTypeBuffer, packedLight, OverlayTexture.field_229196_a_, bakedModel);
                    if (this.transformation != null) {
                        matrixStack.func_227865_b_();
                    }
                    matrixStack.func_227865_b_();
                }
            });
        }
    }

    public static class Builder<T extends LivingEntity, M extends BipedModel<T>> {
        private LivingRenderer<T, M> entityRenderer;
        private ModEquipmentSlotType slot;
        private TransformationMatrix tranformation;
        private boolean useCrouchingOrientation;
        private boolean useHeadOrientation;

        public Builder<T, M> withRenderer(LivingRenderer<T, M> entityRenderer) {
            this.entityRenderer = entityRenderer;
            return this;
        }

        public Builder<T, M> withSlot(ModEquipmentSlotType slot) {
            this.slot = slot;
            return this;
        }

        public Builder<T, M> withArbitraryTransformation(TransformationMatrix transformation) {
            this.tranformation = transformation;
            return this;
        }

        public Builder<T, M> withCrouchingOrientation(boolean useCrouchingOrientation) {
            this.useCrouchingOrientation = useCrouchingOrientation;
            return this;
        }

        public Builder<T, M> withHeadOrientation(boolean useHeadOrientation) {
            this.useHeadOrientation = useHeadOrientation;
            return this;
        }

        public EquipmentLayer<T, M> build() {
            Validate.notNull(this.entityRenderer, (String)"The renderer must not be null", (Object[])new Object[0]);
            Validate.notNull((Object)((Object)this.slot), (String)"The slot must not be null", (Object[])new Object[0]);
            return new EquipmentLayer(this);
        }
    }
}

