/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer;

import com.craftingdead.core.client.renderer.FloatSmoother;
import com.craftingdead.core.util.MutableVector2f;
import java.util.Random;
import net.minecraft.client.util.NativeUtil;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class CameraManager {
    private static final Random random = new Random();
    private static final float LOOK_ROTATION_DECELERATION_PER_SECOND = 100.0f;
    private static final float JOLT_DECELERATION_PER_TICK = 1.0f;
    private FloatSmoother lookPitchSmoother = new FloatSmoother(0.5f);
    private FloatSmoother lookYawSmoother = new FloatSmoother(0.5f);
    private float lastLookTime = Float.MIN_VALUE;
    private FloatSmoother joltPitchSmoother = new FloatSmoother(1.1f);
    private float joltPitch;
    private float lastJoltPitch;
    private FloatSmoother joltRollSmoother = new FloatSmoother(0.75f);
    private float joltRoll;
    private float lastJoltRoll;

    public void randomRecoil(float pitchOffset, boolean modifyLookPosition) {
        this.joltCamera(pitchOffset, pitchOffset * (random.nextBoolean() ? 1.0f : -1.0f) * 0.5f, modifyLookPosition);
    }

    public void joltCamera(float pitchOffset, float yawOffset, boolean moveLookPosition) {
        if (moveLookPosition) {
            this.lookPitchSmoother.add(-pitchOffset);
            this.lookYawSmoother.add(yawOffset);
        }
        this.joltPitchSmoother.add(-pitchOffset * 0.175f);
        this.joltRollSmoother.add(yawOffset * 0.75f);
    }

    public void tick() {
        this.lastJoltPitch = this.joltPitch;
        this.joltPitch = this.joltPitchSmoother.getAndDecelerate(1.0f);
        this.lastJoltRoll = this.joltRoll;
        this.joltRoll = this.joltRollSmoother.getAndDecelerate(0.5f);
    }

    public void getLookRotationDelta(MutableVector2f result) {
        float currentTime = (float)NativeUtil.func_216394_b();
        float timeDelta = Math.min(currentTime - this.lastLookTime, 0.1f);
        this.lastLookTime = currentTime;
        float deceleration = timeDelta * 100.0f;
        result.set(this.lookPitchSmoother.getAndDecelerate(deceleration), this.lookYawSmoother.getAndDecelerate(deceleration));
    }

    public void getCameraRotations(float partialTicks, Vector3f result) {
        result.func_195905_a(this.lerpPitch(partialTicks), 0.0f, this.lerpRoll(partialTicks));
    }

    public float getFov(float partialTicks) {
        return -this.lerpPitch(partialTicks) * 0.025f;
    }

    private float lerpPitch(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.lastJoltPitch, (float)this.joltPitch);
    }

    private float lerpRoll(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.lastJoltRoll, (float)this.joltRoll);
    }
}

