/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.gui;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.client.ClientDist;
import com.craftingdead.core.client.crosshair.Crosshair;
import com.craftingdead.core.client.gui.HitMarker;
import com.craftingdead.core.client.util.RenderUtil;
import com.craftingdead.core.world.damagesource.KillFeedEntry;
import com.craftingdead.core.world.effect.ModMobEffects;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.gun.Gun;
import com.craftingdead.core.world.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.gun.magazine.Magazine;
import com.craftingdead.core.world.item.GrenadeItem;
import com.craftingdead.core.world.item.GunItem;
import com.craftingdead.core.world.item.scope.Scope;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class IngameGui {
    private static final Random random = new Random();
    private static final ResourceLocation HEALTH = new ResourceLocation("craftingdead", "textures/gui/health.png");
    private static final ResourceLocation SHIELD = new ResourceLocation("craftingdead", "textures/gui/shield.png");
    private static final int KILL_FEED_MESSAGE_LIFE_MS = 5000;
    private final Minecraft minecraft;
    private final ClientDist client;
    private final List<KillFeedEntry> killFeedMessages = new LinkedList<KillFeedEntry>();
    private ResourceLocation crosshairLocation;
    private float lastSpread;
    private float lastFlashScale = 0.0f;
    @Nullable
    private HitMarker hitMarker;
    private long killFeedVisibleTimeMs;
    private long killFeedAnimationTimeMs;

    public IngameGui(Minecraft minecraft, ClientDist client, ResourceLocation crosshairLocation) {
        this.minecraft = minecraft;
        this.client = client;
        this.crosshairLocation = crosshairLocation;
    }

    public void setCrosshairLocation(ResourceLocation crosshairLocation) {
        this.crosshairLocation = crosshairLocation;
    }

    public void addKillFeedEntry(KillFeedEntry killFeedMessage) {
        if (this.killFeedMessages.isEmpty()) {
            this.killFeedVisibleTimeMs = 0L;
        }
        this.killFeedMessages.add(killFeedMessage);
    }

    public void displayHitMarker(HitMarker hitMarker) {
        this.hitMarker = hitMarker;
    }

    private void renderGunFlash(AbstractClientPlayerEntity playerEntity, Gun gun, int width, int height, float partialTicks) {
        if (gun.getClient().isFlashing()) {
            RenderSystem.pushMatrix();
            float flashIntensity = (float)(random.nextInt(3) + 5) / 10.0f;
            float scale = this.lastFlashScale = MathHelper.func_219799_g((float)partialTicks, (float)this.lastFlashScale, (float)flashIntensity);
            this.minecraft.func_110434_K().func_110577_a(new ResourceLocation("craftingdead", "textures/flash/white_flash.png"));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(flashIntensity - 0.15f));
            float x = (float)width * 0.625f;
            float y = (float)height * 0.625f;
            float flashWidth = 300.0f;
            float flashHeight = 300.0f;
            RenderSystem.translatef((float)(x - x * scale), (float)(y - y * scale), (float)0.0f);
            RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
            RenderUtil.blit(x - 150.0f, y - 150.0f, 300.0, 300.0);
            RenderSystem.disableBlend();
            RenderSystem.popMatrix();
        }
    }

    private static void renderScopeOverlay(AbstractClientPlayerEntity playerEntity, Scope scope, int width, int height) {
        scope.getOverlayTexture((Entity)playerEntity).ifPresent(overlayTexture -> {
            RenderUtil.bind(overlayTexture);
            double overlayTextureWidth = scope.getOverlayTextureWidth();
            double overlayTextureHeight = scope.getOverlayTextureHeight();
            double scale = RenderUtil.getFitScale(overlayTextureWidth, overlayTextureHeight);
            RenderSystem.enableBlend();
            RenderUtil.blit((double)(width / 2) - (overlayTextureWidth *= scale) / 2.0, (double)(height / 2) - (overlayTextureHeight *= scale) / 2.0, overlayTextureWidth, overlayTextureHeight);
            RenderSystem.disableBlend();
        });
    }

    public void renderOverlay(PlayerExtension<AbstractClientPlayerEntity> player, ItemStack heldStack, @Nullable Gun gun, MatrixStack matrixStack, int width, int height, float partialTicks) {
        RenderSystem.enableTexture();
        if (this.hitMarker != null && this.hitMarker.render(width, height, partialTicks)) {
            this.hitMarker = null;
        }
        this.renderKillFeed(matrixStack, partialTicks);
        AbstractClientPlayerEntity playerEntity = (AbstractClientPlayerEntity)player.getEntity();
        heldStack.getCapability(Capabilities.SCOPE).filter(scope -> scope.isAiming((Entity)playerEntity)).ifPresent(scope -> IngameGui.renderScopeOverlay(playerEntity, scope, width, height));
        EffectInstance flashEffect = ((AbstractClientPlayerEntity)player.getEntity()).func_70660_b((Effect)ModMobEffects.FLASH_BLINDNESS.get());
        if (flashEffect != null) {
            int alpha = (int)(255.0f * (MathHelper.func_76131_a((float)((float)flashEffect.func_76459_b() - partialTicks), (float)0.0f, (float)20.0f) / 20.0f));
            int flashColour = 0xFFFFFF | (alpha & 0xFF) << 24;
            RenderUtil.drawGradientRectangle(0.0, 0.0, width, height, flashColour, flashColour);
        }
        player.getProgressMonitor().ifPresent(observer -> IngameGui.renderProgress(matrixStack, this.minecraft.field_71466_p, width, height, observer.getMessage(), observer.getSubMessage().orElse(null), observer.getProgress(partialTicks)));
        if (gun != null) {
            this.renderGunFlash(playerEntity, gun, width, height, partialTicks);
        }
        if (gun != null) {
            this.renderAmmo(matrixStack, width, height, gun);
        }
        if (player.isCombatModeEnabled()) {
            this.renderCombatMode(player, matrixStack, width, height);
        }
    }

    private void renderKillFeed(MatrixStack matrixStack, float partialTicks) {
        long currentTime;
        float durationPct;
        if (this.killFeedVisibleTimeMs == 0L) {
            this.killFeedVisibleTimeMs = Util.func_211177_b();
            this.killFeedAnimationTimeMs = 0L;
        }
        if ((durationPct = MathHelper.func_76131_a((float)((float)((currentTime = Util.func_211177_b()) - this.killFeedVisibleTimeMs) / 5000.0f), (float)0.0f, (float)1.0f)) == 1.0f && !this.killFeedMessages.isEmpty()) {
            this.killFeedMessages.remove(0);
            if (!this.killFeedMessages.isEmpty()) {
                this.killFeedVisibleTimeMs = Util.func_211177_b();
                this.killFeedAnimationTimeMs = 0L;
            }
        } else if (durationPct >= 0.75f && this.killFeedAnimationTimeMs == 0L) {
            this.killFeedAnimationTimeMs = Util.func_211177_b();
        }
        float animationPct = this.killFeedAnimationTimeMs != 0L ? MathHelper.func_76131_a((float)((float)(currentTime - this.killFeedAnimationTimeMs) / (1250.0f - partialTicks)), (float)0.0f, (float)1.0f) : 0.0f;
        int killFeedMessageX = 5;
        for (int i = 0; i < this.killFeedMessages.size(); ++i) {
            KillFeedEntry killFeedMessage = this.killFeedMessages.get(i);
            float killFeedMessageY = 5.0f + ((float)i - 1.0f * animationPct) * 12.0f;
            this.renderKillFeedEntry(killFeedMessage, matrixStack, 5.0f, killFeedMessageY, i == 0 ? 1.0f - animationPct : 1.0f);
        }
    }

    private void renderKillFeedEntry(KillFeedEntry entry, MatrixStack matrixStack, float x, float y, float alpha) {
        String killerName = entry.getKillerName().getString();
        String deadName = entry.getDeadName().getString();
        int killerNameWidth = this.minecraft.field_71466_p.func_78256_a(killerName);
        int deadNameWidth = this.minecraft.field_71466_p.func_78256_a(deadName);
        int spacing = 20;
        alpha *= entry.getKillerEntityId() == this.minecraft.field_71439_g.func_145782_y() ? 0.7f : 0.5f;
        switch (entry.getType()) {
            case WALLBANG_HEADSHOT: {
                spacing += 16;
            }
            case HEADSHOT: 
            case WALLBANG: {
                spacing += 16;
                break;
            }
        }
        int opacity = Math.min((int)(alpha * 255.0f), 255);
        if (opacity < 8) {
            return;
        }
        int colour = 0 + (opacity << 24);
        RenderUtil.drawGradientRectangle(x, y, x + (float)killerNameWidth + (float)deadNameWidth + (float)spacing, y + 11.0f, colour, colour);
        this.minecraft.field_71466_p.func_238405_a_(matrixStack, killerName, x + 2.0f, y + 2.0f, 0xFFFFFF + ((int)(alpha * 255.0f) << 24));
        this.minecraft.field_71466_p.func_238405_a_(matrixStack, deadName, x + (float)killerNameWidth + (float)spacing - 1.0f, y + 2.0f, 0xFFFFFF + (opacity << 24));
        switch (entry.getType()) {
            case HEADSHOT: {
                RenderSystem.enableBlend();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                RenderUtil.bind(new ResourceLocation("craftingdead", "textures/gui/headshot.png"));
                RenderUtil.blit(x + (float)killerNameWidth + 17.0f, y - 1.0f, 12.0, 12.0);
                RenderSystem.disableBlend();
                break;
            }
            case WALLBANG: {
                RenderSystem.enableBlend();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                RenderUtil.bind(new ResourceLocation("craftingdead", "textures/gui/wallbang.png"));
                RenderUtil.blit(x + (float)killerNameWidth + 35.0f, y - 1.0f, 12.0, 12.0);
                RenderSystem.disableBlend();
                break;
            }
            case WALLBANG_HEADSHOT: {
                RenderSystem.enableBlend();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                RenderUtil.bind(new ResourceLocation("craftingdead", "textures/gui/wallbang.png"));
                RenderUtil.blit(x + (float)killerNameWidth + 35.0f, y - 1.0f, 12.0, 12.0);
                RenderUtil.bind(new ResourceLocation("craftingdead", "textures/gui/headshot.png"));
                RenderUtil.blit(x + (float)killerNameWidth + 35.0f + 14.0f, y - 1.0f, 12.0, 12.0);
                RenderSystem.disableBlend();
                break;
            }
        }
        if (!entry.getWeaponStack().func_190926_b()) {
            double scale;
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)(x + (float)killerNameWidth + 4.0f), (double)(y - 1.0f), (double)0.0);
            if (entry.getWeaponStack().func_77973_b() instanceof GunItem) {
                scale = 0.75;
                RenderSystem.scaled((double)scale, (double)scale, (double)scale);
            }
            if (entry.getWeaponStack().func_77973_b() instanceof GrenadeItem) {
                scale = 0.8;
                RenderSystem.scaled((double)scale, (double)scale, (double)scale);
                RenderSystem.translated((double)4.0, (double)1.0, (double)0.0);
            }
            RenderUtil.renderGuiItem(entry.getWeaponStack(), 0, 0, 0xFFFFFF + (opacity << 24));
            RenderSystem.popMatrix();
        }
    }

    private void renderAmmo(MatrixStack matrixStack, int width, int height, Gun gun) {
        int x = width - 115;
        int boxHeight = 25;
        if (CraftingDead.getInstance().isTravelersBackpacksLoaded() && CapabilityUtils.isWearingBackpack((PlayerEntity)this.minecraft.field_71439_g)) {
            x -= 30;
        }
        RenderUtil.drawGradientRectangle(x - 10, height - boxHeight, x + 30, height, 0, 0x55000000);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x + 30), (int)(height - boxHeight), (int)(x + 30 + 90), (int)height, (int)0x55000000);
        AmmoProvider ammoProvider = gun.getAmmoProvider();
        int ammoCount = ammoProvider.getMagazine().map(Magazine::getSize).orElse(0);
        int reserveSize = ammoProvider.getReserveSize();
        boolean empty = ammoCount == 0 && reserveSize == 0;
        String ammoText = empty ? I18n.func_135052_a((String)"hud.empty_magazine", (Object[])new Object[0]) : String.valueOf(ammoCount);
        int ammoTextWidth = this.minecraft.field_71466_p.func_78256_a(ammoText);
        float reserveTextScale = 0.6f;
        String reserveText = " / " + reserveSize;
        int reserveTextWidth = (int)((float)this.minecraft.field_71466_p.func_78256_a(reserveText) * reserveTextScale);
        FontRenderer fontRenderer = this.minecraft.field_71466_p;
        float f = x + 55 - ammoTextWidth - (empty ? 0 : reserveTextWidth);
        int n = height - boxHeight / 2;
        this.minecraft.field_71466_p.getClass();
        fontRenderer.func_238405_a_(matrixStack, ammoText, f, (float)(n - 9 / 2), empty ? TextFormatting.RED.func_211163_e() : -1);
        if (!empty) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(x + 55 - reserveTextWidth), (double)((float)(height - boxHeight / 2) - reserveTextScale * 2.0f), 0.0);
            matrixStack.func_227862_a_(reserveTextScale, reserveTextScale, reserveTextScale);
            this.minecraft.field_71466_p.func_238405_a_(matrixStack, reserveText, 0.0f, 0.0f, empty ? TextFormatting.RED.func_211163_e() : -1);
            matrixStack.func_227865_b_();
        }
        String fireMode = I18n.func_135052_a((String)gun.getFireMode().getTranslationKey(), (Object[])new Object[0]);
        this.minecraft.field_71466_p.func_238405_a_(matrixStack, fireMode, (float)(x + 65), (float)(height - 16), -1);
    }

    private static void renderProgress(MatrixStack matrixStack, FontRenderer fontRenderer, int width, int height, ITextComponent message, @Nullable ITextComponent subMessage, float percent) {
        int barWidth = 100;
        int barHeight = 10;
        int barColour = -1056964609;
        float x = width / 2 - 50;
        float y = height / 2;
        String string = message.getString();
        fontRenderer.getClass();
        fontRenderer.func_238405_a_(matrixStack, string, x, y - 10.0f - ((float)(9 / 2) + 0.5f), 0xFFFFFF);
        RenderUtil.drawGradientRectangle(x, y, x + 100.0f * percent, y + 10.0f, -1056964609, -1056964609);
        if (subMessage != null) {
            String string2 = subMessage.getString();
            fontRenderer.getClass();
            fontRenderer.func_238405_a_(matrixStack, string2, x, y + 10.0f + ((float)(9 / 2) + 0.5f), 0xFFFFFF);
        }
    }

    private void renderCombatMode(PlayerExtension<AbstractClientPlayerEntity> player, MatrixStack matrixStack, int width, int height) {
        PlayerInventory inventory = ((AbstractClientPlayerEntity)player.getEntity()).field_71071_by;
        int boxX = width - 115;
        int boxWidth = 110;
        int boxY = height - 170;
        int boxHeight = 30;
        int boxMarginY = 31;
        int currentItemIndex = inventory.field_70461_c;
        ItemStack primaryStack = inventory.func_70301_a(0);
        if (currentItemIndex == 0) {
            RenderUtil.fill(matrixStack, boxX + 1, boxY + 1, boxWidth - 2, boxHeight - 2, -855638017);
        }
        RenderUtil.fill(matrixStack, boxX, boxY, boxWidth, boxHeight, 0x66000000);
        this.minecraft.field_71466_p.func_238405_a_(matrixStack, "1", (float)(boxX + 5), (float)(boxY + 5), -1);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(boxX + boxWidth / 2 - 8), (float)(boxY + boxHeight / 2 - 8), (float)0.0f);
        RenderSystem.scalef((float)1.2f, (float)1.2f, (float)1.2f);
        RenderUtil.renderGuiItem(primaryStack, 0, 0, -1, ItemCameraTransforms.TransformType.FIXED);
        RenderSystem.popMatrix();
        ItemStack secondaryStack = inventory.func_70301_a(1);
        boxY += boxMarginY;
        if (currentItemIndex == 1) {
            RenderUtil.fill(matrixStack, boxX + 1, boxY + 1, boxWidth - 2, boxHeight - 2, -855638017);
        }
        RenderUtil.fill(matrixStack, boxX, boxY, boxWidth, boxHeight, 0x66000000);
        this.minecraft.field_71466_p.func_238405_a_(matrixStack, "2", (float)(boxX + 5), (float)(boxY + 5), -1);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(boxX + boxWidth / 2 - 8), (float)(boxY + boxHeight / 2 - 8), (float)0.0f);
        RenderSystem.scalef((float)1.2f, (float)1.2f, (float)1.2f);
        RenderUtil.renderGuiItem(secondaryStack, 0, 0, -1, ItemCameraTransforms.TransformType.FIXED);
        RenderSystem.popMatrix();
        ItemStack meleeStack = inventory.func_70301_a(2);
        boxY += boxMarginY;
        if (currentItemIndex == 2) {
            RenderUtil.fill(matrixStack, boxX + 1, boxY + 1, boxWidth - 2, boxHeight - 2, -855638017);
        }
        RenderUtil.fill(matrixStack, boxX, boxY, boxWidth, boxHeight, 0x66000000);
        this.minecraft.field_71466_p.func_238405_a_(matrixStack, "3", (float)(boxX + 5), (float)(boxY + 5), -1);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(boxX + boxWidth / 2 - 8), (float)(boxY + boxHeight / 2 - 8), (float)0.0f);
        RenderSystem.scalef((float)1.2f, (float)1.2f, (float)1.2f);
        RenderUtil.renderGuiItem(meleeStack, 0, 0, -1, ItemCameraTransforms.TransformType.FIXED);
        RenderSystem.popMatrix();
        boxY += boxMarginY;
        boxHeight = 25;
        boxWidth = 25;
        for (int i = 0; i < 4; ++i) {
            ItemStack extraStack = inventory.func_70301_a(3 + i);
            if (currentItemIndex == 3 + i) {
                RenderUtil.fill(matrixStack, boxX + 1, boxY + 1, boxWidth - 2, boxHeight - 2, -855638017);
            }
            RenderUtil.fill(matrixStack, boxX, boxY, boxWidth, boxHeight, 0x66000000);
            this.minecraft.field_71466_p.func_238405_a_(matrixStack, String.valueOf(4 + i), (float)(boxX + 1), (float)(boxY + 1), -1);
            RenderSystem.pushMatrix();
            RenderUtil.renderGuiItem(extraStack, boxX + boxWidth / 2 - 8, boxY + boxHeight / 2 - 6, -1);
            RenderSystem.popMatrix();
            boxX += 28;
        }
        int healthBoxHeight = 25;
        float health = ((AbstractClientPlayerEntity)player.getEntity()).func_110143_aJ();
        float armour = ((AbstractClientPlayerEntity)player.getEntity()).func_70658_aO();
        int healthWidth = 100;
        if (armour > 0.0f) {
            healthWidth *= 2;
        }
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)(height - 25), (int)healthWidth, (int)height, (int)0x55000000);
        RenderUtil.drawGradientRectangle(healthWidth, height - 25, healthWidth + 40, height, 0x55000000, 0);
        RenderUtil.bind(HEALTH);
        RenderSystem.enableBlend();
        RenderUtil.blit(5.0, height - 12 - 8, 16.0, 16.0);
        RenderSystem.disableBlend();
        FontRenderer fontRenderer = this.minecraft.field_71466_p;
        String string = String.valueOf(Math.round(health));
        this.minecraft.field_71466_p.getClass();
        AbstractGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)fontRenderer, (String)string, (int)31, (int)(height - 12 - 9 / 2), (int)-1);
        RenderUtil.fill(matrixStack, 42, height - 12 - 5, 65, 10, 0x66000000);
        RenderUtil.fill(matrixStack, 42, height - 12 - 5, Math.round(65.0f * (health / ((AbstractClientPlayerEntity)player.getEntity()).func_110138_aP())), 10, -855638017);
        if (armour > 0.0f) {
            int armourX = healthWidth / 2 + 7;
            RenderUtil.bind(SHIELD);
            RenderSystem.enableBlend();
            RenderUtil.blit(armourX + 5, height - 12 - 8, 16.0, 16.0);
            RenderSystem.disableBlend();
            FontRenderer fontRenderer2 = this.minecraft.field_71466_p;
            String string2 = String.valueOf(Math.round(armour));
            this.minecraft.field_71466_p.getClass();
            AbstractGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)fontRenderer2, (String)string2, (int)(armourX + 31), (int)(height - 12 - 9 / 2), (int)-1);
            RenderUtil.fill(matrixStack, armourX + 42, height - 12 - 5, 65, 10, 0x66000000);
            RenderUtil.fill(matrixStack, armourX + 42, height - 12 - 5, Math.round(65.0f * (armour / 20.0f)), 10, -855638017);
        }
    }

    public void renderCrosshairs(float accuracy, float partialTicks, int width, int height) {
        double imageWidth = 16.0;
        double imageHeight = 16.0;
        double x = (double)width / 2.0 - 8.0 - 0.5;
        double y = (double)height / 2.0 - 8.0;
        float newSpread = (1.15f - accuracy) * 60.0f;
        float lerpSpread = MathHelper.func_219799_g((float)0.5f, (float)this.lastSpread, (float)newSpread);
        Crosshair crosshair = this.client.getCrosshairManager().getCrosshair(this.crosshairLocation);
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderUtil.bind(crosshair.getMiddle());
        RenderUtil.blit(x, y, 16.0, 16.0);
        RenderUtil.bind(crosshair.getTop());
        RenderUtil.blit(x, y - (double)lerpSpread, 16.0, 16.0);
        RenderUtil.bind(crosshair.getBottom());
        RenderUtil.blit(x, y + (double)lerpSpread, 16.0, 16.0);
        RenderUtil.bind(crosshair.getLeft());
        RenderUtil.blit(x - (double)lerpSpread, y, 16.0, 16.0);
        RenderUtil.bind(crosshair.getRight());
        RenderUtil.blit(x + (double)lerpSpread, y, 16.0, 16.0);
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
        this.lastSpread = lerpSpread;
    }
}

