/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.animation.inspect;

import com.craftingdead.core.client.animation.GunAnimation;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3f;

public abstract class GunAnimationInspect
extends GunAnimation {
    protected float rotation1 = 0.0f;
    protected float lastRotation1 = 0.0f;
    protected float maxRotation1 = 55.0f;
    protected float trans1 = 0.0f;
    protected float lastTrans1 = 0.0f;
    protected float maxTrans1 = 0.6f;
    protected boolean up = true;

    @Override
    public void onUpdate(Minecraft par1, LivingEntity par2, ItemStack par3, float progress) {
        if (progress > 0.8f) {
            this.up = false;
        }
        this.lastRotation1 = this.rotation1;
        this.lastTrans1 = this.trans1;
        float roation1Speed = 15.0f;
        float transSpeed = 0.15f;
        if (this.up) {
            this.trans1 += transSpeed;
            if (this.trans1 > this.maxTrans1) {
                this.trans1 = this.maxTrans1;
            }
            this.rotation1 += roation1Speed;
        } else {
            this.rotation1 -= roation1Speed;
            this.trans1 -= transSpeed;
            if (this.trans1 < 0.0f) {
                this.trans1 = 0.0f;
            }
        }
        if (this.rotation1 > this.maxRotation1) {
            this.rotation1 = this.maxRotation1;
        }
        if (this.rotation1 < 0.0f) {
            this.rotation1 = 0.0f;
        }
    }

    @Override
    public void doRender(ItemStack par1, float par2, MatrixStack matrixStack) {
        float transprogress = this.lastTrans1 + (this.trans1 - this.lastTrans1) * par2;
        matrixStack.func_227861_a_((double)transprogress, 0.0, (double)transprogress);
        float progress = this.lastRotation1 + (this.rotation1 - this.lastRotation1) * par2;
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-progress));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(progress / 3.0f));
    }

    @Override
    public void onAnimationStopped(ItemStack par1) {
    }

    @Override
    public float getMaxAnimationTick() {
        return 100.0f;
    }

    @Override
    protected boolean isAcceptedTransformType(ItemCameraTransforms.TransformType transformType) {
        return transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND ? false : super.isAcceptedTransformType(transformType);
    }
}

