/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core;

import com.craftingdead.core.ModDist;
import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.capability.SerializableCapabilityProvider;
import com.craftingdead.core.client.ClientDist;
import com.craftingdead.core.data.ModItemTagsProvider;
import com.craftingdead.core.data.ModRecipeProvider;
import com.craftingdead.core.event.CombatPickupEvent;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.SyncLivingMessage;
import com.craftingdead.core.particle.ModParticleTypes;
import com.craftingdead.core.server.ServerDist;
import com.craftingdead.core.sounds.ModSoundEvents;
import com.craftingdead.core.world.action.ActionTypes;
import com.craftingdead.core.world.effect.ModMobEffects;
import com.craftingdead.core.world.entity.ModEntityTypes;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.entity.extension.PlayerHandler;
import com.craftingdead.core.world.gun.ammoprovider.AmmoProviderTypes;
import com.craftingdead.core.world.gun.attachment.Attachments;
import com.craftingdead.core.world.inventory.ModMenuTypes;
import com.craftingdead.core.world.item.ArbitraryTooltips;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.combatslot.CombatSlotType;
import com.craftingdead.core.world.item.crafting.ModRecipeSerializers;
import com.craftingdead.core.world.item.enchantment.ModEnchantments;
import io.netty.buffer.Unpooled;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.data.ForgeBlockTagsProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.JarVersionLookupHandler;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="craftingdead")
public class CraftingDead {
    public static final String ID = "craftingdead";
    public static final String VERSION = JarVersionLookupHandler.getImplementationVersion(CraftingDead.class).orElse("[version]");
    private static final String TRAVELERS_BACKPACK_ID = "travelersbackpack";
    private static final Logger logger = LogManager.getLogger();
    private static CraftingDead instance;
    private final ModDist modDist;
    private boolean travelersBackpacksLoaded;

    public CraftingDead() {
        instance = this;
        this.modDist = (ModDist)DistExecutor.safeRunForDist(() -> ClientDist::new, () -> ServerDist::new);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::handleCommonSetup);
        modEventBus.addListener(this::handleGatherData);
        ModEntityTypes.ENTITY_TYPES.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModSoundEvents.SOUND_EVENTS.register(modEventBus);
        ModMenuTypes.MENUS.register(modEventBus);
        ModMobEffects.MOB_EFFECTS.register(modEventBus);
        ModEnchantments.ENCHANTMENTS.register(modEventBus);
        ModParticleTypes.PARTICLE_TYPES.register(modEventBus);
        ModRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        ActionTypes.ACTION_TYPES.register(modEventBus);
        AmmoProviderTypes.AMMO_PROVIDER_TYPES.register(modEventBus);
        Attachments.ATTACHMENTS.register(modEventBus);
        modEventBus.addGenericListener(Item.class, ArbitraryTooltips::registerAll);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ModDist getModDist() {
        return this.modDist;
    }

    public ClientDist getClientDist() {
        if (this.modDist instanceof ClientDist) {
            return (ClientDist)this.modDist;
        }
        throw new IllegalStateException("Accessing client dist on wrong side");
    }

    public boolean isTravelersBackpacksLoaded() {
        return this.travelersBackpacksLoaded;
    }

    public static CraftingDead getInstance() {
        return instance;
    }

    private void handleCommonSetup(FMLCommonSetupEvent event) {
        logger.info("Starting Crafting Dead, version {}", (Object)VERSION);
        NetworkChannel.loadChannels();
        this.travelersBackpacksLoaded = ModList.get().isLoaded(TRAVELERS_BACKPACK_ID);
        if (this.travelersBackpacksLoaded) {
            logger.info("Adding integration for travelersbackpack");
        }
        event.enqueueWork(() -> BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.SYRINGE.get()}), (Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax}), (ItemStack)new ItemStack((IItemProvider)ModItems.ADRENALINE_SYRINGE.get())));
    }

    private void handleGatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        if (event.includeServer()) {
            dataGenerator.func_200390_a((IDataProvider)new ModItemTagsProvider(dataGenerator, (BlockTagsProvider)new ForgeBlockTagsProvider(dataGenerator, event.getExistingFileHelper()), event.getExistingFileHelper()));
            dataGenerator.func_200390_a((IDataProvider)new ModRecipeProvider(dataGenerator));
        }
    }

    @SubscribeEvent
    public void handleEntityItemPickup(EntityItemPickupEvent event) {
        event.getPlayer().getCapability(Capabilities.LIVING_EXTENSION).cast().filter(PlayerExtension::isCombatModeEnabled).ifPresent(living -> {
            CombatSlotType combatSlotType;
            ItemStack itemStack = event.getItem().func_92059_d();
            CombatPickupEvent combatPickupEvent = new CombatPickupEvent(itemStack, combatSlotType = (CombatSlotType)CombatSlotType.getSlotType(itemStack).orElse(null));
            if (MinecraftForge.EVENT_BUS.post((Event)combatPickupEvent)) {
                event.setCanceled(true);
            } else if (combatSlotType != null) {
                if (combatSlotType.addToInventory(itemStack, event.getPlayer().field_71071_by, false)) {
                    event.setResult(Event.Result.ALLOW);
                } else {
                    event.setCanceled(true);
                }
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleLivingSetTarget(LivingSetAttackTargetEvent event) {
        MobEntity mobEntity;
        if (event.getTarget() != null && event.getEntityLiving() instanceof MobEntity && (mobEntity = (MobEntity)event.getEntityLiving()).func_70644_a((Effect)ModMobEffects.FLASH_BLINDNESS.get())) {
            mobEntity.func_70624_b(null);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleLivingDeath(LivingDeathEvent event) {
        if (event.getEntity().getCapability(Capabilities.LIVING_EXTENSION).map(living -> living.handleDeath(event.getSource())).orElse(false).booleanValue() || event.getSource().func_76346_g() != null && event.getSource().func_76346_g().getCapability(Capabilities.LIVING_EXTENSION).map(living -> living.handleKill(event.getEntity())).orElse(false).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleLivingDrops(LivingDropsEvent event) {
        event.getEntity().getCapability(Capabilities.LIVING_EXTENSION).ifPresent(living -> event.setCanceled(living.handleDeathLoot(event.getSource(), event.getDrops())));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleLivingAttack(LivingAttackEvent event) {
        event.getEntity().getCapability(Capabilities.LIVING_EXTENSION).ifPresent(living -> event.setCanceled(living.handleHurt(event.getSource(), event.getAmount())));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleLivingDamage(LivingDamageEvent event) {
        event.getEntity().getCapability(Capabilities.LIVING_EXTENSION).ifPresent(living -> event.setAmount(living.handleDamaged(event.getSource(), event.getAmount())));
    }

    @SubscribeEvent
    public void handlePlayerClone(PlayerEvent.Clone event) {
        PlayerExtension.getOrThrow(event.getPlayer()).copyFrom(PlayerExtension.getOrThrow(event.getOriginal()), event.isWasDeath());
    }

    @SubscribeEvent
    public void handleLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        event.getEntityLiving().getCapability(Capabilities.LIVING_EXTENSION).ifPresent(living -> {
            living.tick();
            if (!living.getLevel().func_201670_d() && living.requiresSync()) {
                PacketBuffer data = new PacketBuffer(Unpooled.buffer());
                living.encode(data, false);
                NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(living::getEntity), (Object)new SyncLivingMessage(living.getEntity().func_145782_y(), data));
            }
        });
    }

    @SubscribeEvent
    public void handlePlayerTick(TickEvent.PlayerTickEvent event) {
        switch (event.phase) {
            case END: {
                event.player.getCapability(Capabilities.LIVING_EXTENSION).filter(living -> living instanceof PlayerExtension).map(living -> (PlayerExtension)living).ifPresent(PlayerHandler::playerTick);
                break;
            }
        }
    }

    @SubscribeEvent
    public void handleAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            LivingExtension<Object, PlayerHandler> living = event.getObject() instanceof PlayerEntity ? PlayerExtension.create((PlayerEntity)event.getObject()) : LivingExtension.create((LivingEntity)event.getObject());
            event.addCapability(LivingExtension.CAPABILITY_KEY, new SerializableCapabilityProvider(LazyOptional.of(() -> living), () -> Capabilities.LIVING_EXTENSION, CompoundNBT::new));
            living.load();
        }
    }

    @SubscribeEvent
    public void handlePlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        PlayerExtension.getOrThrow(event.getPlayer()).encode(data, true);
        NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> ((PlayerEvent.PlayerChangedDimensionEvent)event).getPlayer()), (Object)new SyncLivingMessage(event.getPlayer().func_145782_y(), data));
    }

    @SubscribeEvent
    public void handlePlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        CraftingDead.startTracking((Entity)event.getPlayer(), (ServerPlayerEntity)event.getPlayer());
    }

    @SubscribeEvent
    public void handlePlayerStartTracking(PlayerEvent.StartTracking event) {
        CraftingDead.startTracking(event.getTarget(), (ServerPlayerEntity)event.getPlayer());
    }

    private static void startTracking(Entity targetEntity, ServerPlayerEntity playerEntity) {
        targetEntity.getCapability(Capabilities.LIVING_EXTENSION).ifPresent(trackedLiving -> {
            trackedLiving.handleStartTracking(playerEntity);
            PacketBuffer data = new PacketBuffer(Unpooled.buffer());
            trackedLiving.encode(data, true);
            NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> playerEntity), (Object)new SyncLivingMessage(trackedLiving.getEntity().func_145782_y(), data));
        });
    }
}

