/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity.device;

import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.inventory.container.device.DeviceHiveExtractorContainer;
import cofh.thermal.core.util.managers.device.HiveExtractorManager;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.tileentity.DeviceTileBase;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DeviceHiveExtractorTile
extends DeviceTileBase {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "Fluid");
    protected ItemStorageCoFH outputSlot = new ItemStorageCoFH();
    protected FluidStorageCoFH outputTank = new FluidStorageCoFH(8000);

    public DeviceHiveExtractorTile() {
        super(TCoreReferences.DEVICE_HIVE_EXTRACTOR_TILE);
        this.inventory.addSlot(this.outputSlot, StorageGroup.OUTPUT);
        this.tankInv.addTank(this.outputTank, StorageGroup.OUTPUT);
        this.addAugmentSlots(ThermalConfig.deviceAugments);
        this.initHandlers();
    }

    @Override
    protected void updateActiveState() {
        super.updateActiveState();
        if (this.isActive) {
            this.extractProducts(this.field_174879_c.func_177984_a());
        }
    }

    @Override
    protected boolean isValid() {
        return this.field_145850_b != null && this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_235901_b_((Property)BeehiveBlock.field_226873_c_);
    }

    protected void extractProducts(BlockPos above) {
        if (this.field_145850_b == null) {
            return;
        }
        BlockState hive = this.field_145850_b.func_180495_p(above);
        if (hive.func_235901_b_((Property)BeehiveBlock.field_226873_c_) && BeehiveTileEntity.func_226964_a_((BlockState)hive) >= 5) {
            ItemStack comb = HiveExtractorManager.instance().getItem(hive);
            FluidStack honey = HiveExtractorManager.instance().getFluid(hive);
            this.outputSlot.insertItem(0, comb, false);
            this.outputTank.fill(honey, IFluidHandler.FluidAction.EXECUTE);
            this.field_145850_b.func_180501_a(above, (BlockState)hive.func_206870_a((Property)BeehiveBlock.field_226873_c_, (Comparable)Integer.valueOf(0)), 3);
        }
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new DeviceHiveExtractorContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }
}

