/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.crt.machine;

import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.machine.RefineryRecipe;
import cofh.thermal.lib.compat.crt.actions.ActionRemoveThermalRecipeByOutput;
import cofh.thermal.lib.compat.crt.base.CRTHelper;
import cofh.thermal.lib.compat.crt.base.CRTRecipe;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.util.RecipePrintingUtil;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.item.MCWeightedItemStack;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.thermal.Refinery")
@IRecipeHandler.For(value=RefineryRecipe.class)
public class CRTRefineryManager
implements IRecipeManager,
IRecipeHandler<RefineryRecipe> {
    @ZenCodeType.Method
    public void addRecipe(String name, MCWeightedItemStack itemOutput, IFluidStack[] fluidsOutput, CTFluidIngredient inputFluid, int energy) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        CRTRecipe crtRecipe = new CRTRecipe(resourceLocation).energy(energy).input(inputFluid).output(fluidsOutput).output(itemOutput);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)crtRecipe.recipe(RefineryRecipe::new)));
    }

    public IRecipeType<RefineryRecipe> getRecipeType() {
        return TCoreRecipeTypes.RECIPE_REFINERY;
    }

    public void removeRecipe(IItemStack output) {
        this.removeRecipe(new IItemStack[]{output}, new IFluidStack[0]);
    }

    @ZenCodeType.Method
    public void removeRecipe(IItemStack[] itemOutputs, IFluidStack[] fluidOutputs) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveThermalRecipeByOutput(this, (IIngredient[])itemOutputs, fluidOutputs));
    }

    public String dumpToCommandString(IRecipeManager manager, RefineryRecipe recipe) {
        return String.format("<recipetype:%s>.addRecipe(\"%s\", %s, [%s], %s, %s);", recipe.func_222127_g(), recipe.func_199560_c(), recipe.getOutputItems().isEmpty() ? ((MCItemStack)MCItemStack.EMPTY.get()).getCommandString() : RecipePrintingUtil.stringifyWeightedStacks(recipe.getOutputItems(), recipe.getOutputItemChances(), (String)" | "), RecipePrintingUtil.stringifyFluidStacks(recipe.getOutputFluids(), (String)", "), CRTHelper.stringifyFluidIngredients(recipe.getInputFluids()), recipe.getEnergy());
    }

    public Optional<Function<ResourceLocation, RefineryRecipe>> replaceIngredients(IRecipeManager manager, RefineryRecipe recipe, List<IReplacementRule> rules) {
        return Optional.empty();
    }
}

