/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.DataHandlerUtils;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.TextUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class StorageUtils {
    private StorageUtils() {
    }

    public static void addStoredEnergy(@Nonnull ItemStack stack, @Nonnull List<ITextComponent> tooltip, boolean showMissingCap) {
        StorageUtils.addStoredEnergy(stack, tooltip, showMissingCap, MekanismLang.STORED_ENERGY);
    }

    public static void addStoredEnergy(@Nonnull ItemStack stack, @Nonnull List<ITextComponent> tooltip, boolean showMissingCap, ILangEntry langEntry) {
        if (Capabilities.STRICT_ENERGY_CAPABILITY != null) {
            Optional capability = stack.getCapability(Capabilities.STRICT_ENERGY_CAPABILITY).resolve();
            if (capability.isPresent()) {
                IStrictEnergyHandler energyHandlerItem = (IStrictEnergyHandler)capability.get();
                int energyContainerCount = energyHandlerItem.getEnergyContainerCount();
                for (int container = 0; container < energyContainerCount; ++container) {
                    tooltip.add((ITextComponent)langEntry.translateColored(EnumColor.BRIGHT_GREEN, EnumColor.GRAY, EnergyDisplay.of(energyHandlerItem.getEnergy(container), energyHandlerItem.getMaxEnergy(container))));
                }
            } else if (showMissingCap) {
                tooltip.add((ITextComponent)langEntry.translateColored(EnumColor.BRIGHT_GREEN, EnumColor.GRAY, EnergyDisplay.ZERO));
            }
        }
    }

    public static void addStoredGas(@Nonnull ItemStack stack, @Nonnull List<ITextComponent> tooltip, boolean showMissingCap, boolean showAttributes) {
        StorageUtils.addStoredGas(stack, tooltip, showMissingCap, showAttributes, MekanismLang.NO_GAS);
    }

    public static void addStoredGas(@Nonnull ItemStack stack, @Nonnull List<ITextComponent> tooltip, boolean showMissingCap, boolean showAttributes, ILangEntry emptyLangEntry) {
        StorageUtils.addStoredChemical(stack, tooltip, showMissingCap, showAttributes, emptyLangEntry, stored -> {
            if (stored.isEmpty()) {
                return emptyLangEntry.translateColored(EnumColor.GRAY, new Object[0]);
            }
            return MekanismLang.STORED.translateColored(EnumColor.ORANGE, EnumColor.ORANGE, stored, EnumColor.GRAY, MekanismLang.GENERIC_MB.translate(TextUtils.format(stored.getAmount())));
        }, Capabilities.GAS_HANDLER_CAPABILITY);
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> void addStoredChemical(@Nonnull ItemStack stack, @Nonnull List<ITextComponent> tooltip, boolean showMissingCap, boolean showAttributes, ILangEntry emptyLangEntry, Function<STACK, ITextComponent> storedFunction, Capability<HANDLER> capability) {
        if (capability != null) {
            Optional cap = stack.getCapability(capability).resolve();
            if (cap.isPresent()) {
                IChemicalHandler handler = (IChemicalHandler)cap.get();
                int tanks = handler.getTanks();
                for (int tank = 0; tank < tanks; ++tank) {
                    Object chemicalInTank = handler.getChemicalInTank(tank);
                    tooltip.add(storedFunction.apply(chemicalInTank));
                    if (!showAttributes) continue;
                    ChemicalUtil.addAttributeTooltips(tooltip, ((ChemicalStack)chemicalInTank).getType());
                }
            } else if (showMissingCap) {
                tooltip.add((ITextComponent)emptyLangEntry.translate(new Object[0]));
            }
        }
    }

    public static void addStoredSubstance(@Nonnull ItemStack stack, @Nonnull List<ITextComponent> tooltip, boolean isCreative) {
        MekanismLang type;
        long amount;
        Object contents;
        if (Capabilities.GAS_HANDLER_CAPABILITY == null || Capabilities.INFUSION_HANDLER_CAPABILITY == null || Capabilities.PIGMENT_HANDLER_CAPABILITY == null || Capabilities.SLURRY_HANDLER_CAPABILITY == null || CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY == null) {
            return;
        }
        FluidStack fluidStack = StorageUtils.getStoredFluidFromNBT(stack);
        GasStack gasStack = StorageUtils.getStoredGasFromNBT(stack);
        InfusionStack infusionStack = StorageUtils.getStoredInfusionFromNBT(stack);
        PigmentStack pigmentStack = StorageUtils.getStoredPigmentFromNBT(stack);
        SlurryStack slurryStack = StorageUtils.getStoredSlurryFromNBT(stack);
        if (fluidStack.isEmpty() && gasStack.isEmpty() && infusionStack.isEmpty() && pigmentStack.isEmpty() && slurryStack.isEmpty()) {
            tooltip.add((ITextComponent)MekanismLang.EMPTY.translate(new Object[0]));
            return;
        }
        if (!fluidStack.isEmpty()) {
            contents = fluidStack;
            amount = fluidStack.getAmount();
            type = MekanismLang.LIQUID;
        } else {
            ChemicalStack chemicalStack;
            if (!gasStack.isEmpty()) {
                chemicalStack = gasStack;
                type = MekanismLang.GAS;
            } else if (!infusionStack.isEmpty()) {
                chemicalStack = infusionStack;
                type = MekanismLang.INFUSE_TYPE;
            } else if (!pigmentStack.isEmpty()) {
                chemicalStack = pigmentStack;
                type = MekanismLang.PIGMENT;
            } else if (!slurryStack.isEmpty()) {
                chemicalStack = slurryStack;
                type = MekanismLang.SLURRY;
            } else {
                throw new IllegalStateException("Unknown chemical");
            }
            contents = chemicalStack;
            amount = chemicalStack.getAmount();
        }
        if (isCreative) {
            tooltip.add((ITextComponent)type.translateColored(EnumColor.YELLOW, EnumColor.ORANGE, MekanismLang.GENERIC_STORED.translate(contents, EnumColor.GRAY, MekanismLang.INFINITE)));
        } else {
            tooltip.add((ITextComponent)type.translateColored(EnumColor.YELLOW, EnumColor.ORANGE, MekanismLang.GENERIC_STORED_MB.translate(contents, EnumColor.GRAY, TextUtils.format(amount))));
        }
    }

    @Nonnull
    public static FluidStack getStoredFluidFromNBT(ItemStack stack) {
        BasicFluidTank tank = BasicFluidTank.create(Integer.MAX_VALUE, null);
        DataHandlerUtils.readContainers(Collections.singletonList(tank), ItemDataUtils.getList(stack, "FluidTanks"));
        return tank.getFluid();
    }

    @Nonnull
    public static GasStack getStoredGasFromNBT(ItemStack stack) {
        return StorageUtils.getStoredChemicalFromNBT(stack, ChemicalTankBuilder.GAS.createDummy(Long.MAX_VALUE), "GasTanks");
    }

    @Nonnull
    public static InfusionStack getStoredInfusionFromNBT(ItemStack stack) {
        return StorageUtils.getStoredChemicalFromNBT(stack, ChemicalTankBuilder.INFUSION.createDummy(Long.MAX_VALUE), "InfusionTanks");
    }

    @Nonnull
    public static PigmentStack getStoredPigmentFromNBT(ItemStack stack) {
        return StorageUtils.getStoredChemicalFromNBT(stack, ChemicalTankBuilder.PIGMENT.createDummy(Long.MAX_VALUE), "PigmentTanks");
    }

    @Nonnull
    public static SlurryStack getStoredSlurryFromNBT(ItemStack stack) {
        return StorageUtils.getStoredChemicalFromNBT(stack, ChemicalTankBuilder.SLURRY.createDummy(Long.MAX_VALUE), "SlurryTanks");
    }

    @Nonnull
    private static <STACK extends ChemicalStack<?>> STACK getStoredChemicalFromNBT(ItemStack stack, IChemicalTank<?, STACK> tank, String tag) {
        DataHandlerUtils.readContainers(Collections.singletonList(tank), ItemDataUtils.getList(stack, tag));
        return tank.getStack();
    }

    public static FloatingLong getStoredEnergyFromNBT(ItemStack stack) {
        BasicEnergyContainer container = BasicEnergyContainer.create(FloatingLong.MAX_VALUE, null);
        DataHandlerUtils.readContainers(Collections.singletonList(container), ItemDataUtils.getList(stack, "EnergyContainers"));
        return container.getEnergy();
    }

    public static ItemStack getFilledEnergyVariant(ItemStack toFill, FloatingLong capacity) {
        BasicEnergyContainer container = BasicEnergyContainer.create(capacity, null);
        container.setEnergy(capacity);
        ItemDataUtils.setList(toFill, "EnergyContainers", DataHandlerUtils.writeContainers(Collections.singletonList(container)));
        return toFill;
    }

    @Nullable
    public static IEnergyContainer getEnergyContainer(ItemStack stack, int container) {
        IStrictEnergyHandler energyHandlerItem;
        Optional energyCapability;
        if (!stack.func_190926_b() && (energyCapability = stack.getCapability(Capabilities.STRICT_ENERGY_CAPABILITY).resolve()).isPresent() && (energyHandlerItem = (IStrictEnergyHandler)energyCapability.get()) instanceof IMekanismStrictEnergyHandler) {
            return ((IMekanismStrictEnergyHandler)energyHandlerItem).getEnergyContainer(container, null);
        }
        return null;
    }

    public static double getEnergyRatio(ItemStack stack) {
        IEnergyContainer container = StorageUtils.getEnergyContainer(stack, 0);
        double ratio = 0.0;
        if (container != null) {
            ratio = container.getEnergy().divideToLevel(container.getMaxEnergy());
        }
        return ratio;
    }

    public static ITextComponent getEnergyPercent(ItemStack stack, boolean colorText) {
        return StorageUtils.getStoragePercent(StorageUtils.getEnergyRatio(stack), colorText);
    }

    public static ITextComponent getStoragePercent(double ratio, boolean colorText) {
        ITextComponent text = TextUtils.getPercent(ratio);
        if (!colorText) {
            return text;
        }
        EnumColor color = ratio < (double)0.01f ? EnumColor.DARK_RED : (ratio < (double)0.1f ? EnumColor.RED : (ratio < 0.25 ? EnumColor.ORANGE : (ratio < 0.5 ? EnumColor.YELLOW : EnumColor.BRIGHT_GREEN)));
        return TextComponentUtil.build(color, text);
    }

    public static double getDurabilityForDisplay(ItemStack stack) {
        if (Capabilities.GAS_HANDLER_CAPABILITY == null || Capabilities.INFUSION_HANDLER_CAPABILITY == null || Capabilities.PIGMENT_HANDLER_CAPABILITY == null || Capabilities.SLURRY_HANDLER_CAPABILITY == null || CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY == null) {
            return 1.0;
        }
        double bestRatio = 0.0;
        bestRatio = StorageUtils.calculateRatio(stack, bestRatio, Capabilities.GAS_HANDLER_CAPABILITY);
        bestRatio = StorageUtils.calculateRatio(stack, bestRatio, Capabilities.INFUSION_HANDLER_CAPABILITY);
        bestRatio = StorageUtils.calculateRatio(stack, bestRatio, Capabilities.PIGMENT_HANDLER_CAPABILITY);
        bestRatio = StorageUtils.calculateRatio(stack, bestRatio, Capabilities.SLURRY_HANDLER_CAPABILITY);
        Optional fluidCapability = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
        if (fluidCapability.isPresent()) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)fluidCapability.get();
            int tanks = fluidHandlerItem.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                bestRatio = Math.max(bestRatio, StorageUtils.getRatio(fluidHandlerItem.getFluidInTank(tank).getAmount(), fluidHandlerItem.getTankCapacity(tank)));
            }
        }
        return 1.0 - bestRatio;
    }

    public static double getEnergyDurabilityForDisplay(ItemStack stack) {
        if (Capabilities.STRICT_ENERGY_CAPABILITY == null) {
            return 1.0;
        }
        double bestRatio = 0.0;
        Optional energyCapability = stack.getCapability(Capabilities.STRICT_ENERGY_CAPABILITY).resolve();
        if (energyCapability.isPresent()) {
            IStrictEnergyHandler energyHandlerItem = (IStrictEnergyHandler)energyCapability.get();
            int containers = energyHandlerItem.getEnergyContainerCount();
            for (int container = 0; container < containers; ++container) {
                bestRatio = Math.max(bestRatio, energyHandlerItem.getEnergy(container).divideToLevel(energyHandlerItem.getMaxEnergy(container)));
            }
        }
        return 1.0 - bestRatio;
    }

    private static double calculateRatio(ItemStack stack, double bestRatio, Capability<? extends IChemicalHandler<?, ?>> capability) {
        Optional cap = stack.getCapability(capability).resolve();
        if (cap.isPresent()) {
            IChemicalHandler handler = (IChemicalHandler)cap.get();
            int tanks = handler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                bestRatio = Math.max(bestRatio, StorageUtils.getRatio(((ChemicalStack)handler.getChemicalInTank(tank)).getAmount(), handler.getTankCapacity(tank)));
            }
        }
        return bestRatio;
    }

    public static double getRatio(long amount, long capacity) {
        return capacity == 0L ? 1.0 : (double)amount / (double)capacity;
    }

    public static void mergeTanks(IExtendedFluidTank tank, IExtendedFluidTank mergeTank) {
        if (tank.isEmpty()) {
            tank.setStack(mergeTank.getFluid());
        } else if (!mergeTank.isEmpty() && tank.isFluidEqual(mergeTank.getFluid())) {
            tank.growStack(mergeTank.getFluidAmount(), Action.EXECUTE);
        }
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void mergeTanks(IChemicalTank<CHEMICAL, STACK> tank, IChemicalTank<CHEMICAL, STACK> mergeTank) {
        if (tank.isEmpty()) {
            tank.setStack(mergeTank.getStack());
        } else if (!mergeTank.isEmpty() && tank.isTypeEqual(mergeTank.getStack())) {
            tank.growStack(mergeTank.getStored(), Action.EXECUTE);
        }
    }

    public static void mergeContainers(IEnergyContainer container, IEnergyContainer mergeContainer) {
        container.setEnergy(container.getEnergy().add(mergeContainer.getEnergy()));
    }

    public static void mergeContainers(IHeatCapacitor capacitor, IHeatCapacitor mergeCapacitor) {
        capacitor.setHeat(capacitor.getHeat() + mergeCapacitor.getHeat());
        if (capacitor instanceof BasicHeatCapacitor) {
            ((BasicHeatCapacitor)capacitor).setHeatCapacity(capacitor.getHeatCapacity() + mergeCapacitor.getHeatCapacity(), false);
        }
    }
}

