/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.PressurizedReactionCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.PRCEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.ITripleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityPressurizedReactionChamber
extends TileEntityProgressMachine<PressurizedReactionRecipe>
implements ITripleRecipeLookupHandler.ItemFluidChemicalRecipeLookupHandler<Gas, GasStack, PressurizedReactionRecipe> {
    private static final int BASE_DURATION = 100;
    private static final long MAX_GAS = 10000L;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getInputFluid", "getInputFluidCapacity", "getInputFluidNeeded", "getInputFluidFilledPercentage"})
    public BasicFluidTank inputFluidTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getInputGas", "getInputGasCapacity", "getInputGasNeeded", "getInputGasFilledPercentage"})
    public IGasTank inputGasTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getOutputGas", "getOutputGasCapacity", "getOutputGasNeeded", "getOutputGasFilledPercentage"})
    public IGasTank outputGasTank;
    private FloatingLong recipeEnergyRequired = FloatingLong.ZERO;
    private final IOutputHandler<@NonNull Pair<@NonNull ItemStack, @NonNull GasStack>> outputHandler;
    private final IInputHandler<@NonNull ItemStack> itemInputHandler;
    private final IInputHandler<@NonNull FluidStack> fluidInputHandler;
    private final IInputHandler<@NonNull GasStack> gasInputHandler;
    private PRCEnergyContainer energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"})
    private InputInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"})
    private OutputInventorySlot outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityPressurizedReactionChamber() {
        super(MekanismBlocks.PRESSURIZED_REACTION_CHAMBER, 100);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY, TransmissionType.FLUID, TransmissionType.GAS);
        this.configComponent.setupItemIOConfig(this.inputSlot, this.outputSlot, this.energySlot);
        this.configComponent.setupInputConfig(TransmissionType.FLUID, this.inputFluidTank);
        this.configComponent.setupIOConfig(TransmissionType.GAS, this.inputGasTank, this.outputGasTank, RelativeSide.RIGHT, false, true).setEjecting(true);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM, TransmissionType.GAS).setCanTankEject(tank -> tank != this.inputGasTank);
        this.itemInputHandler = InputHelper.getInputHandler(this.inputSlot);
        this.fluidInputHandler = InputHelper.getInputHandler(this.inputFluidTank);
        this.gasInputHandler = InputHelper.getInputHandler(this.inputGasTank);
        this.outputHandler = OutputHelper.getOutputHandler(this.outputGasTank, (IInventorySlot)this.outputSlot);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGasWithConfig(this::getDirection, this::getConfig);
        this.inputGasTank = ChemicalTankBuilder.GAS.create(10000L, (type, automationType) -> automationType != AutomationType.EXTERNAL || this.outputGasTank.isEmpty() && type.has(GasAttributes.Radiation.class), (gas, automationType) -> this.containsRecipeCAB(this.inputSlot.getStack(), this.inputFluidTank.getFluid(), (Chemical)gas), this::containsRecipeC, ChemicalAttributeValidator.ALWAYS_ALLOW, (IContentsListener)this.recipeCacheLookupMonitor);
        builder.addTank(this.inputGasTank);
        this.outputGasTank = ChemicalTankBuilder.GAS.output(10000L, this);
        builder.addTank(this.outputGasTank);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        FluidTankHelper builder = FluidTankHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.inputFluidTank = BasicFluidTank.input(10000, fluid -> this.containsRecipeBAC(this.inputSlot.getStack(), fluid, this.inputGasTank.getStack()), this::containsRecipeB, this.recipeCacheLookupMonitor);
        builder.addTank(this.inputFluidTank);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = PRCEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.inputSlot = InputInventorySlot.at(item -> this.containsRecipeABC(item, this.inputFluidTank.getFluid(), this.inputGasTank.getStack()), this::containsRecipeA, (IContentsListener)this.recipeCacheLookupMonitor, 54, 35);
        builder.addSlot(this.inputSlot);
        this.outputSlot = OutputInventorySlot.at(this, 116, 35);
        builder.addSlot(this.outputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityPressurizedReactionChamber)this).func_145831_w(), this, 141, 17);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    @Override
    public void onCachedRecipeChanged(@Nullable CachedRecipe<PressurizedReactionRecipe> cachedRecipe, int cacheIndex) {
        int recipeDuration;
        if (cachedRecipe == null) {
            recipeDuration = 100;
            this.recipeEnergyRequired = FloatingLong.ZERO;
        } else {
            PressurizedReactionRecipe recipe = cachedRecipe.getRecipe();
            recipeDuration = recipe.getDuration();
            this.recipeEnergyRequired = recipe.getEnergyRequired();
        }
        boolean update = this.baseTicksRequired != recipeDuration;
        this.baseTicksRequired = recipeDuration;
        if (update) {
            this.recalculateUpgrades(Upgrade.SPEED);
        }
        this.energyContainer.updateEnergyPerTick();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.recipeCacheLookupMonitor.updateAndProcess();
    }

    public FloatingLong getRecipeEnergyRequired() {
        return this.recipeEnergyRequired;
    }

    @Override
    @Nonnull
    public MekanismRecipeType<PressurizedReactionRecipe, InputRecipeCache.ItemFluidChemical<Gas, GasStack, PressurizedReactionRecipe>> getRecipeType() {
        return MekanismRecipeType.REACTION;
    }

    @Override
    @Nullable
    public PressurizedReactionRecipe getRecipe(int cacheIndex) {
        return (PressurizedReactionRecipe)this.findFirstRecipe(this.itemInputHandler, this.fluidInputHandler, this.gasInputHandler);
    }

    @Override
    @Nonnull
    public CachedRecipe<PressurizedReactionRecipe> createNewCachedRecipe(@Nonnull PressurizedReactionRecipe recipe, int cacheIndex) {
        return new PressurizedReactionCachedRecipe(recipe, this.itemInputHandler, this.fluidInputHandler, this.gasInputHandler, this.outputHandler).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(this::setOperatingTicks);
    }

    public PRCEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    @ComputerMethod
    private FloatingLong getEnergyUsage() {
        return this.getActive() ? this.energyContainer.getEnergyPerTick() : FloatingLong.ZERO;
    }
}

