/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.math;

import java.util.Random;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import net.minecraft.util.math.vector.Vector3d;

public class Plane {
    private final Vector3d minPos;
    private final Vector3d maxPos;

    public Plane(Vector3d minPos, Vector3d maxPos) {
        this.minPos = minPos;
        this.maxPos = maxPos;
    }

    public static Plane getInnerCuboidPlane(VoxelCuboid cuboid, VoxelCuboid.CuboidSide side) {
        int minX = cuboid.getMinPos().func_177958_n() + 1;
        int minY = cuboid.getMinPos().func_177956_o() + 1;
        int minZ = cuboid.getMinPos().func_177952_p() + 1;
        int maxX = cuboid.getMaxPos().func_177958_n();
        int maxY = cuboid.getMaxPos().func_177956_o();
        int maxZ = cuboid.getMaxPos().func_177952_p();
        switch (side) {
            case NORTH: {
                return new Plane(new Vector3d((double)minX, (double)minY, (double)minZ), new Vector3d((double)maxX, (double)maxY, (double)minZ));
            }
            case SOUTH: {
                return new Plane(new Vector3d((double)minX, (double)minY, (double)maxZ), new Vector3d((double)maxX, (double)maxY, (double)maxZ));
            }
            case WEST: {
                return new Plane(new Vector3d((double)minX, (double)minY, (double)minZ), new Vector3d((double)minX, (double)maxY, (double)maxZ));
            }
            case EAST: {
                return new Plane(new Vector3d((double)maxX, (double)minY, (double)minZ), new Vector3d((double)maxX, (double)maxY, (double)maxZ));
            }
            case BOTTOM: {
                return new Plane(new Vector3d((double)minX, (double)minY, (double)minZ), new Vector3d((double)maxX, (double)minY, (double)maxZ));
            }
            case TOP: {
                return new Plane(new Vector3d((double)minX, (double)maxY, (double)minZ), new Vector3d((double)maxX, (double)maxY, (double)maxZ));
            }
        }
        return null;
    }

    public Vector3d getRandomPoint(Random rand) {
        return new Vector3d(this.minPos.field_72450_a + rand.nextDouble() * (this.maxPos.field_72450_a - this.minPos.field_72450_a), this.minPos.field_72448_b + rand.nextDouble() * (this.maxPos.field_72448_b - this.minPos.field_72448_b), this.minPos.field_72449_c + rand.nextDouble() * (this.maxPos.field_72449_c - this.minPos.field_72449_c));
    }
}

