/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.item.RateLimitEnergyHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemElectricBow
extends BowItem
implements IModeItem,
IItemHUDProvider {
    public ItemElectricBow(Item.Properties properties) {
        super(properties.func_208103_a(Rarity.RARE).setNoRepair().func_200917_a(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        StorageUtils.addStoredEnergy(stack, tooltip, true);
        tooltip.add((ITextComponent)MekanismLang.FIRE_MODE.translateColored(EnumColor.PINK, BooleanStateDisplay.OnOff.of(this.getFireState(stack))));
    }

    public void func_77615_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            IEnergyContainer energyContainer = null;
            boolean fireState = this.getFireState(stack);
            if (!player.func_184812_l_()) {
                FloatingLong energyNeeded;
                energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                FloatingLong floatingLong = energyNeeded = fireState ? (FloatingLong)MekanismConfig.gear.electricBowEnergyUsageFire.get() : (FloatingLong)MekanismConfig.gear.electricBowEnergyUsage.get();
                if (energyContainer == null || energyContainer.extract(energyNeeded, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyNeeded)) {
                    return;
                }
            }
            boolean infinity = player.func_184812_l_() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack ammo = player.func_213356_f(stack);
            int charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (PlayerEntity)player, (int)(this.func_77626_a(stack) - timeLeft), (!ammo.func_190926_b() || infinity ? 1 : 0) != 0);
            if (charge < 0) {
                return;
            }
            if (!ammo.func_190926_b() || infinity) {
                boolean noConsume;
                float velocity = ItemElectricBow.func_185059_b((int)charge);
                if ((double)velocity < 0.1) {
                    return;
                }
                if (ammo.func_190926_b()) {
                    ammo = new ItemStack((IItemProvider)Items.field_151032_g);
                }
                boolean bl = noConsume = player.func_184812_l_() || ammo.func_77973_b() instanceof ArrowItem && ((ArrowItem)ammo.func_77973_b()).isInfinite(ammo, stack, player);
                if (!world.field_72995_K) {
                    int punch;
                    int power;
                    ArrowItem arrowitem = (ArrowItem)(ammo.func_77973_b() instanceof ArrowItem ? ammo.func_77973_b() : Items.field_151032_g);
                    AbstractArrowEntity arrowEntity = arrowitem.func_200887_a(world, ammo, (LivingEntity)player);
                    arrowEntity = this.customArrow(arrowEntity);
                    arrowEntity.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 3.0f * velocity, 1.0f);
                    if (velocity == 1.0f) {
                        arrowEntity.func_70243_d(true);
                    }
                    if ((power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                        arrowEntity.func_70239_b(arrowEntity.func_70242_d() + 0.5 * (double)power + 0.5);
                    }
                    if ((punch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                        arrowEntity.func_70240_a(punch);
                    }
                    if (fireState || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                        arrowEntity.func_70015_d(100);
                    }
                    if (!player.func_184812_l_() && energyContainer != null) {
                        energyContainer.extract(fireState ? (FloatingLong)MekanismConfig.gear.electricBowEnergyUsageFire.get() : (FloatingLong)MekanismConfig.gear.electricBowEnergyUsage.get(), Action.EXECUTE, AutomationType.MANUAL);
                    }
                    if (noConsume || player.func_184812_l_() && (ammo.func_77973_b() == Items.field_185166_h || ammo.func_77973_b() == Items.field_185167_i)) {
                        arrowEntity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                    }
                    world.func_217376_c((Entity)arrowEntity);
                }
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + velocity * 0.5f);
                if (!noConsume && !player.func_184812_l_()) {
                    ammo.func_190918_g(1);
                    if (ammo.func_190926_b()) {
                        player.field_71071_by.func_184437_d(ammo);
                    }
                }
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            }
        }
    }

    public void setFireState(ItemStack stack, boolean state) {
        ItemDataUtils.setBoolean(stack, "mode", state);
    }

    public boolean getFireState(ItemStack stack) {
        return ItemDataUtils.getBoolean(stack, "mode");
    }

    @Override
    public void addHUDStrings(List<ITextComponent> list, PlayerEntity player, ItemStack stack, EquipmentSlotType slotType) {
        list.add((ITextComponent)MekanismLang.FIRE_MODE.translateColored(EnumColor.PINK, BooleanStateDisplay.OnOff.of(this.getFireState(stack))));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return StorageUtils.getEnergyDurabilityForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MekanismConfig.client.energyColor.get();
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (this.func_194125_a(group)) {
            items.add((Object)StorageUtils.getFilledEnergyVariant(new ItemStack((IItemProvider)this), (FloatingLong)MekanismConfig.gear.electricBowMaxEnergy.get()));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new ItemCapabilityWrapper(stack, RateLimitEnergyHandler.create(MekanismConfig.gear.electricBowChargeRate, MekanismConfig.gear.electricBowMaxEnergy, BasicEnergyContainer.manualOnly, BasicEnergyContainer.alwaysTrue));
    }

    @Override
    public void changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        if (Math.abs(shift) % 2 == 1) {
            boolean newState = !this.getFireState(stack);
            this.setFireState(stack, newState);
            if (displayChangeMessage) {
                player.func_145747_a(MekanismUtils.logFormat(MekanismLang.FIRE_MODE.translate(BooleanStateDisplay.OnOff.of(newState, true))), Util.field_240973_b_);
            }
        }
    }

    @Override
    @Nonnull
    public ITextComponent getScrollTextComponent(@Nonnull ItemStack stack) {
        return MekanismLang.FIRE_MODE.translateColored(EnumColor.PINK, BooleanStateDisplay.OnOff.of(this.getFireState(stack), true));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }
}

