/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.IModuleItem;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemModule
extends Item
implements IModuleItem {
    private final IModuleDataProvider<?> moduleData;

    public ItemModule(IModuleDataProvider<?> moduleData, Item.Properties properties) {
        super(properties);
        this.moduleData = moduleData;
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.getModuleData().getMaxStackSize();
    }

    @Override
    public ModuleData<?> getModuleData() {
        return this.moduleData.getModuleData();
    }

    @Nonnull
    public Rarity func_77613_e(@Nonnull ItemStack stack) {
        return this.getModuleData().getRarity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed(MekanismKeyHandler.detailsKey)) {
            for (Item item : MekanismAPI.getModuleHelper().getSupported(this.getModuleData())) {
                tooltip.add(item.func_200295_i(new ItemStack((IItemProvider)item)));
            }
        } else {
            ModuleData<?> moduleData = this.getModuleData();
            tooltip.add((ITextComponent)TextComponentUtil.translate(moduleData.getDescriptionTranslationKey(), new Object[0]));
            tooltip.add((ITextComponent)MekanismLang.MODULE_STACKABLE.translateColored(EnumColor.GRAY, EnumColor.AQUA, moduleData.getMaxStackSize()));
            tooltip.add((ITextComponent)MekanismLang.HOLD_FOR_SUPPORTED_ITEMS.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismKeyHandler.detailsKey.func_238171_j_()));
        }
    }

    @Nonnull
    public String func_77658_a() {
        return this.getModuleData().getTranslationKey();
    }
}

