/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.gui.GuiUtils;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public abstract class LookingAtElement {
    private final int borderColor;
    private final int textColor;

    protected LookingAtElement(int borderColor, int textColor) {
        this.borderColor = borderColor;
        this.textColor = textColor;
    }

    public void render(@Nonnull MatrixStack matrix, int x, int y) {
        int scale;
        int width = this.getWidth();
        int height = this.getHeight();
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)x, (int)y, (int)(x + width - 1), (int)(y + 1), (int)this.borderColor);
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)x, (int)y, (int)(x + 1), (int)(y + height - 1), (int)this.borderColor);
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(x + width - 1), (int)y, (int)(x + width), (int)(y + height - 1), (int)this.borderColor);
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height), (int)this.borderColor);
        TextureAtlasSprite icon = this.getIcon();
        if (icon != null && (scale = this.getScaledLevel(width - 2)) > 0) {
            boolean colored = this.applyRenderColor();
            GuiUtils.drawTiledSprite(matrix, x + 1, y + 1, height - 2, scale, height - 2, icon, 16, 16, 0, GuiUtils.TilingDirection.DOWN_RIGHT);
            if (colored) {
                MekanismRenderer.resetColor();
            }
        }
        LookingAtElement.renderScaledText(Minecraft.func_71410_x(), matrix, x + 4, y + 3, this.textColor, this.getWidth() - 8, this.getText());
    }

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return 13;
    }

    public abstract int getScaledLevel(int var1);

    @Nullable
    public abstract TextureAtlasSprite getIcon();

    public abstract ITextComponent getText();

    protected boolean applyRenderColor() {
        return false;
    }

    public static void renderScaledText(Minecraft mc, @Nonnull MatrixStack matrix, int x, int y, int color, int maxWidth, ITextComponent component) {
        int length = mc.field_71466_p.func_238414_a_((ITextProperties)component);
        if (length <= maxWidth) {
            mc.field_71466_p.func_243248_b(matrix, component, (float)x, (float)y, color);
        } else {
            float scale = (float)maxWidth / (float)length;
            float reverse = 1.0f / scale;
            float yAdd = 4.0f - scale * 8.0f / 2.0f;
            matrix.func_227860_a_();
            matrix.func_227862_a_(scale, scale, scale);
            mc.field_71466_p.func_243248_b(matrix, component, (float)((int)((float)x * reverse)), (float)((int)((float)y * reverse + yAdd)), color);
            matrix.func_227865_b_();
        }
        MekanismRenderer.resetColor();
    }
}

