/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.impl.fluid.MCFluidStack;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.RotaryIRecipe;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.Rotary")
public class RotaryRecipeManager
extends MekanismRecipeManager<RotaryRecipe> {
    public static final RotaryRecipeManager INSTANCE = new RotaryRecipeManager();

    private RotaryRecipeManager() {
        super(MekanismRecipeType.ROTARY);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, FluidStackIngredient fluidInput, ICrTChemicalStack.ICrTGasStack gasOutput) {
        this.addRecipe(new RotaryIRecipe(this.getAndValidateName(name), fluidInput, this.getAndValidateNotEmpty(gasOutput)));
    }

    @ZenCodeType.Method
    public void addRecipe(String name, GasStackIngredient gasInput, IFluidStack fluidOutput) {
        this.addRecipe(new RotaryIRecipe(this.getAndValidateName(name), gasInput, this.getAndValidateNotEmpty(fluidOutput)));
    }

    @ZenCodeType.Method
    public void addRecipe(String name, FluidStackIngredient fluidInput, GasStackIngredient gasInput, ICrTChemicalStack.ICrTGasStack gasOutput, IFluidStack fluidOutput) {
        this.addRecipe(new RotaryIRecipe(this.getAndValidateName(name), fluidInput, gasInput, this.getAndValidateNotEmpty(gasOutput), this.getAndValidateNotEmpty(fluidOutput)));
    }

    @Override
    protected MekanismRecipeManager.ActionAddMekanismRecipe getAction(RotaryRecipe recipe) {
        return new MekanismRecipeManager.ActionAddMekanismRecipe(recipe){

            @Override
            protected String describeOutputs() {
                RotaryRecipe recipe = (RotaryRecipe)this.getRecipe();
                StringBuilder builder = new StringBuilder();
                if (recipe.hasFluidToGas()) {
                    builder.append(CrTUtils.describeOutputs(recipe.getGasOutputDefinition(), CrTChemicalStack.CrTGasStack::new)).append(" for fluid to gas");
                }
                if (recipe.hasGasToFluid()) {
                    if (recipe.hasFluidToGas()) {
                        builder.append(" and ");
                    }
                    builder.append(CrTUtils.describeOutputs(recipe.getFluidOutputDefinition(), MCFluidStack::new)).append(" for gas to fluid");
                }
                return builder.toString();
            }
        };
    }
}

