/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.lib.effect.BillboardingEffectRenderer;
import mekanism.client.render.lib.effect.BoltRenderer;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.content.sps.SPSMultiblockData;
import mekanism.common.lib.Color;
import mekanism.common.lib.effect.BoltEffect;
import mekanism.common.lib.effect.CustomEffect;
import mekanism.common.lib.math.Plane;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.particle.SPSOrbitEffect;
import mekanism.common.tile.multiblock.TileEntitySPSCasing;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

@ParametersAreNonnullByDefault
public class RenderSPS
extends MekanismTileEntityRenderer<TileEntitySPSCasing> {
    private static final CustomEffect CORE = new CustomEffect(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "energy_effect.png"));
    private static final Map<UUID, BoltRenderer> boltRendererMap = new HashMap<UUID, BoltRenderer>();
    private static final float MIN_SCALE = 0.1f;
    private static final float MAX_SCALE = 4.0f;
    private static final Random rand = new Random();
    private final Minecraft minecraft = Minecraft.func_71410_x();

    public static void clearBoltRenderers() {
        boltRendererMap.clear();
    }

    public RenderSPS(TileEntityRendererDispatcher renderer) {
        super(renderer);
        CORE.setColor(Color.rgbai(255, 255, 255, 240));
    }

    @Override
    protected void render(TileEntitySPSCasing tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        SPSMultiblockData multiblock;
        if (tile.isMaster() && (multiblock = (SPSMultiblockData)tile.getMultiblock()).isFormed() && multiblock.renderLocation != null && multiblock.getBounds() != null) {
            BoltRenderer bolts = boltRendererMap.computeIfAbsent(multiblock.inventoryID, mb -> new BoltRenderer());
            Vector3d center = Vector3d.func_237491_b_((Vector3i)multiblock.getMinPos()).func_178787_e(Vector3d.func_237491_b_((Vector3i)multiblock.getMaxPos())).func_178787_e(new Vector3d(1.0, 1.0, 1.0)).func_186678_a(0.5);
            Vector3d renderCenter = center.func_178786_a((double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p());
            if (!this.minecraft.func_147113_T()) {
                for (SPSMultiblockData.CoilData data : multiblock.coilData.coilMap.values()) {
                    if (data.prevLevel <= 0) continue;
                    bolts.update(data.coilPos.hashCode(), RenderSPS.getBoltFromData(data, tile.func_174877_v(), multiblock, renderCenter), partialTick);
                }
            }
            float energyScale = RenderSPS.getEnergyScale(multiblock.lastProcessed);
            int targetEffectCount = 0;
            if (!this.minecraft.func_147113_T() && !multiblock.lastReceivedEnergy.isZero()) {
                if (rand.nextDouble() < (double)RenderSPS.getBoundedScale(energyScale, 0.01f, 0.4f)) {
                    VoxelCuboid.CuboidSide side = VoxelCuboid.CuboidSide.SIDES[rand.nextInt(6)];
                    Plane plane = Plane.getInnerCuboidPlane(multiblock.getBounds(), side);
                    Vector3d endPos = plane.getRandomPoint(rand).func_178786_a((double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p());
                    BoltEffect bolt = new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, renderCenter, endPos, 15).size(0.01f * RenderSPS.getBoundedScale(energyScale, 0.5f, 5.0f)).lifespan(8).spawn(BoltEffect.SpawnFunction.NO_DELAY);
                    bolts.update(Objects.hash(new Object[]{side, endPos}), bolt, partialTick);
                }
                targetEffectCount = (int)RenderSPS.getBoundedScale(energyScale, 10.0f, 120.0f);
            }
            if (tile.orbitEffects.size() > targetEffectCount) {
                tile.orbitEffects.poll();
            } else if (tile.orbitEffects.size() < targetEffectCount && rand.nextDouble() < 0.5) {
                tile.orbitEffects.add(new SPSOrbitEffect(multiblock, center));
            }
            bolts.render(partialTick, matrix, renderer);
            if (multiblock.lastProcessed > 0.0) {
                CORE.setPos(center);
                CORE.setScale(RenderSPS.getBoundedScale(energyScale, 0.1f, 4.0f));
                BillboardingEffectRenderer.render(CORE, tile.func_174877_v(), matrix, renderer, tile.func_145831_w().func_82737_E(), partialTick);
            }
            tile.orbitEffects.forEach(effect -> BillboardingEffectRenderer.render(effect, tile.func_174877_v(), matrix, renderer, tile.func_145831_w().func_82737_E(), partialTick));
        }
    }

    private static float getEnergyScale(double lastProcessed) {
        return (float)Math.min(1.0, Math.max(0.0, (Math.log10(lastProcessed) + 2.0) / 4.0));
    }

    private static float getBoundedScale(float scale, float min, float max) {
        return min + scale * (max - min);
    }

    private static BoltEffect getBoltFromData(SPSMultiblockData.CoilData data, BlockPos pos, SPSMultiblockData multiblock, Vector3d center) {
        Vector3d start = Vector3d.func_237489_a_((Vector3i)data.coilPos.func_177972_a(data.side));
        start = start.func_178787_e(Vector3d.func_237491_b_((Vector3i)data.side.func_176730_m()).func_186678_a(0.5));
        int count = 1 + (data.prevLevel - 1) / 2;
        float size = 0.01f * (float)data.prevLevel;
        return new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, start.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), center, 15).count(count).size(size).lifespan(8).spawn(BoltEffect.SpawnFunction.delay(4.0f));
    }

    @Override
    protected String getProfilerSection() {
        return "supercriticalPhaseShifter";
    }

    public boolean shouldRenderOffScreen(TileEntitySPSCasing tile) {
        if (tile.isMaster()) {
            SPSMultiblockData multiblock = (SPSMultiblockData)tile.getMultiblock();
            return multiblock.isFormed() && multiblock.renderLocation != null;
        }
        return false;
    }
}

