/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.slot.BinInventorySlot;
import mekanism.common.tier.BinTier;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class RenderBin
extends MekanismTileEntityRenderer<TileEntityBin> {
    private static final Matrix3f FAKE_NORMALS;

    public RenderBin(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    @Override
    protected void render(TileEntityBin tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        World world = tile.func_145831_w();
        BinInventorySlot binSlot = tile.getBinSlot();
        if (world != null && !binSlot.isEmpty()) {
            Direction facing = tile.getDirection();
            BlockPos coverPos = tile.func_174877_v().func_177972_a(facing);
            Optional<BlockState> blockState = WorldUtils.getBlockState((IBlockReader)world, coverPos);
            if (!(blockState.isPresent() && blockState.get().func_200132_m() && blockState.get().func_224755_d((IBlockReader)world, coverPos, facing.func_176734_d()))) {
                TranslationTextComponent amount = tile.getTier() == BinTier.CREATIVE ? MekanismLang.INFINITE.translate(new Object[0]) : TextComponentUtil.build(binSlot.getCount());
                matrix.func_227860_a_();
                matrix.func_227866_c_().func_227872_b_().func_226114_a_(FAKE_NORMALS);
                switch (facing) {
                    case NORTH: {
                        matrix.func_227861_a_(0.73, 0.83, -1.0E-4);
                        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                        break;
                    }
                    case SOUTH: {
                        matrix.func_227861_a_(0.27, 0.83, 1.0001);
                        break;
                    }
                    case WEST: {
                        matrix.func_227861_a_(-1.0E-4, 0.83, 0.27);
                        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                        break;
                    }
                    case EAST: {
                        matrix.func_227861_a_(1.0001, 0.83, 0.73);
                        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                        break;
                    }
                }
                float scale = 0.03125f;
                float scaler = 0.9f;
                matrix.func_227862_a_(scale * scaler, scale * scaler, 1.0E-4f);
                matrix.func_227861_a_(8.0, -8.0, 8.0);
                matrix.func_227862_a_(16.0f, 16.0f, 16.0f);
                light = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)tile.func_174877_v().func_177972_a(facing));
                Minecraft.func_71410_x().func_175599_af().func_229110_a_(binSlot.getStack(), ItemCameraTransforms.TransformType.GUI, light, overlayLight, matrix, renderer);
                matrix.func_227865_b_();
                this.renderText(matrix, renderer, light, overlayLight, (ITextComponent)amount, facing, 0.02f);
            }
        }
    }

    @Override
    protected String getProfilerSection() {
        return "bin";
    }

    private void renderText(@Nonnull MatrixStack matrix, @Nonnull IRenderTypeBuffer renderer, int light, int overlayLight, ITextComponent text, Direction side, float maxScale) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, -0.3725, 0.0);
        switch (side) {
            case SOUTH: {
                matrix.func_227861_a_(0.0, 1.0, 1.0E-4);
                matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                break;
            }
            case NORTH: {
                matrix.func_227861_a_(1.0, 1.0, 0.9999);
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                break;
            }
            case EAST: {
                matrix.func_227861_a_(1.0E-4, 1.0, 1.0);
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                break;
            }
            case WEST: {
                matrix.func_227861_a_(0.9999, 1.0, 0.0);
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            }
        }
        float displayWidth = 1.0f;
        float displayHeight = 1.0f;
        matrix.func_227861_a_((double)(displayWidth / 2.0f), 1.0, (double)(displayHeight / 2.0f));
        matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        FontRenderer font = this.field_228858_b_.func_147548_a();
        int requiredWidth = Math.max(font.func_238414_a_((ITextProperties)text), 1);
        font.getClass();
        int requiredHeight = 9 + 2;
        float scaler = 0.4f;
        float scaleX = displayWidth / (float)requiredWidth;
        float scale = scaleX * scaler;
        if (maxScale > 0.0f) {
            scale = Math.min(scale, maxScale);
        }
        matrix.func_227862_a_(scale, -scale, scale);
        int realHeight = (int)Math.floor(displayHeight / scale);
        int realWidth = (int)Math.floor(displayWidth / scale);
        int offsetX = (realWidth - requiredWidth) / 2;
        int offsetY = (realHeight - requiredHeight) / 2;
        font.func_243247_a((ITextComponent)TextComponentUtil.build(EnumColor.WHITE, text), (float)(offsetX - realWidth / 2), (float)(1 + offsetY - realHeight / 2), overlayLight, false, matrix.func_227866_c_().func_227870_a_(), renderer, false, 0, light);
        matrix.func_227865_b_();
    }

    static {
        Vector3f NORMAL = new Vector3f(1.0f, 1.0f, 1.0f);
        NORMAL.func_229194_d_();
        FAKE_NORMALS = new Matrix3f(new Quaternion(NORMAL, 0.0f, true));
    }
}

