/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiEnergyGauge;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.common.MekanismLang;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.EnergyDisplay;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class ItemStackToEnergyRecipeCategory
extends BaseRecipeCategory<ItemStackToEnergyRecipe> {
    private static final ResourceLocation iconRL = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "energy.png");
    private final Map<ItemStackToEnergyRecipe, IGuiItemStackGroup> ingredients = new WeakHashMap<ItemStackToEnergyRecipe, IGuiItemStackGroup>();
    private final GuiEnergyGauge gauge = this.addElement(GuiEnergyGauge.getDummy(GaugeType.STANDARD.with(DataType.OUTPUT), this, 133, 13));
    private final GuiSlot input = this.addSlot(SlotType.INPUT, 26, 36);

    public ItemStackToEnergyRecipeCategory(IGuiHelper helper, ResourceLocation id) {
        super(helper, id, (ITextComponent)MekanismLang.CONVERSION_ENERGY.translate(new Object[0]), ItemStackToEnergyRecipeCategory.createIcon(helper, iconRL), 20, 12, 132, 62);
        this.addConstantProgress(ProgressType.LARGE_RIGHT, 64, 40);
    }

    public Class<? extends ItemStackToEnergyRecipe> getRecipeClass() {
        return ItemStackToEnergyRecipe.class;
    }

    public void setIngredients(ItemStackToEnergyRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getInput().getRepresentations()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, ItemStackToEnergyRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        this.initItem((IGuiIngredientGroup<ItemStack>)itemStackGroup, 0, true, this.input, recipe.getInput().getRepresentations());
        this.ingredients.put(recipe, itemStackGroup);
    }

    @Override
    public void draw(ItemStackToEnergyRecipe recipe, MatrixStack matrix, double mouseX, double mouseY) {
        super.draw(recipe, matrix, mouseX, mouseY);
        if (!recipe.getOutputDefinition().isZero()) {
            this.gauge.renderContents(matrix);
        }
    }

    public List<ITextComponent> getTooltipStrings(ItemStackToEnergyRecipe recipe, double mouseX, double mouseY) {
        FloatingLong energy;
        if (this.gauge.func_231047_b_(mouseX, mouseY) && !(energy = this.getOutputEnergy(recipe)).isZero()) {
            ITextComponent energyOutput = EnergyDisplay.of(energy).getTextComponent();
            if (Minecraft.func_71410_x().field_71474_y.field_82882_x || Screen.func_231173_s_()) {
                return Arrays.asList(energyOutput, TextComponentUtil.build(TextFormatting.DARK_GRAY, MekanismLang.JEI_RECIPE_ID.translate(recipe.func_199560_c())));
            }
            return Collections.singletonList(energyOutput);
        }
        return Collections.emptyList();
    }

    private FloatingLong getOutputEnergy(ItemStackToEnergyRecipe recipe) {
        ItemStack displayedIngredient;
        IGuiIngredient guiIngredient;
        IGuiIngredientGroup group = (IGuiIngredientGroup)this.ingredients.get(recipe);
        if (group != null && (guiIngredient = (IGuiIngredient)group.getGuiIngredients().get(0)) != null && (displayedIngredient = (ItemStack)guiIngredient.getDisplayedIngredient()) != null && !displayedIngredient.func_190926_b()) {
            return recipe.getOutput(displayedIngredient);
        }
        return recipe.getOutputDefinition();
    }
}

