/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.GuiUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.text.TextUtils;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.text.ITextComponent;

public class ChemicalStackRenderer<STACK extends ChemicalStack<?>>
implements IIngredientRenderer<STACK> {
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private static final int MIN_CHEMICAL_HEIGHT = 1;
    private final long capacityMb;
    private final TooltipMode tooltipMode;
    private final int width;
    private final int height;
    @Nullable
    private final IDrawable overlay;

    public ChemicalStackRenderer() {
        this(1000L, TooltipMode.ITEM_LIST, 16, 16, null);
    }

    public ChemicalStackRenderer(long capacityMb, int width, int height) {
        this(capacityMb, TooltipMode.SHOW_AMOUNT, width, height, null);
    }

    public ChemicalStackRenderer(long capacityMb, int width, int height, @Nullable IDrawable overlay) {
        this(capacityMb, TooltipMode.SHOW_AMOUNT, width, height, overlay);
    }

    private ChemicalStackRenderer(long capacityMb, TooltipMode tooltipMode, int width, int height, @Nullable IDrawable overlay) {
        this.capacityMb = capacityMb;
        this.tooltipMode = tooltipMode;
        this.width = width;
        this.height = height;
        this.overlay = overlay;
    }

    public void render(@Nonnull MatrixStack matrix, int xPosition, int yPosition, @Nullable STACK stack) {
        if (stack == null || ((ChemicalStack)stack).isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        this.drawChemical(matrix, xPosition, yPosition, stack);
        if (this.overlay != null) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, 0.0, 200.0);
            this.overlay.draw(matrix, xPosition, yPosition);
            matrix.func_227865_b_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    private void drawChemical(MatrixStack matrix, int xPosition, int yPosition, @Nonnull STACK stack) {
        int desiredHeight = MathUtils.clampToInt((double)this.height * (double)((ChemicalStack)stack).getAmount() / (double)this.capacityMb);
        if (desiredHeight < 1) {
            desiredHeight = 1;
        }
        if (desiredHeight > this.height) {
            desiredHeight = this.height;
        }
        Object chemical = ((ChemicalStack)stack).getType();
        MekanismRenderer.color(chemical);
        GuiUtils.drawTiledSprite(matrix, xPosition, yPosition, this.height, this.width, desiredHeight, MekanismRenderer.getSprite(((Chemical)chemical).getIcon()), 16, 16, 100, GuiUtils.TilingDirection.UP_RIGHT, false);
        MekanismRenderer.resetColor();
    }

    public List<ITextComponent> getTooltip(@Nonnull STACK stack, ITooltipFlag tooltipFlag) {
        Object chemical = ((ChemicalStack)stack).getType();
        if (((Chemical)chemical).isEmptyType()) {
            return Collections.emptyList();
        }
        ArrayList<ITextComponent> tooltips = new ArrayList<ITextComponent>();
        tooltips.add((ITextComponent)TextComponentUtil.build(chemical));
        if (this.tooltipMode == TooltipMode.SHOW_AMOUNT_AND_CAPACITY) {
            tooltips.add((ITextComponent)MekanismLang.JEI_AMOUNT_WITH_CAPACITY.translateColored(EnumColor.GRAY, TextUtils.format(((ChemicalStack)stack).getAmount()), TextUtils.format(this.capacityMb)));
        } else if (this.tooltipMode == TooltipMode.SHOW_AMOUNT) {
            tooltips.add((ITextComponent)MekanismLang.GENERIC_MB.translateColored(EnumColor.GRAY, TextUtils.format(((ChemicalStack)stack).getAmount())));
        }
        ChemicalUtil.addChemicalDataToTooltip(tooltips, ((ChemicalStack)stack).getType(), tooltipFlag.func_194127_a());
        return tooltips;
    }

    public FontRenderer getFontRenderer(Minecraft minecraft, @Nonnull STACK stack) {
        return minecraft.field_71466_p;
    }

    static enum TooltipMode {
        SHOW_AMOUNT,
        SHOW_AMOUNT_AND_CAPACITY,
        ITEM_LIST;

    }
}

