/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.robit;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.client.SpecialColors;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiSideHolder;
import mekanism.client.gui.element.bar.GuiHorizontalPowerBar;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.window.GuiRobitRename;
import mekanism.client.gui.element.window.GuiRobitSkinSelect;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.entity.EntityRobit;
import mekanism.common.inventory.container.entity.robit.MainRobitContainer;
import mekanism.common.network.to_server.PacketGuiButtonPress;
import mekanism.common.network.to_server.PacketRobit;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiRobitMain
extends GuiMekanism<MainRobitContainer> {
    private final EntityRobit robit;
    private MekanismImageButton renameButton;
    private MekanismImageButton skinButton;

    public GuiRobitMain(MainRobitContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.robit = (EntityRobit)container.getEntity();
        this.dynamicSlots = true;
        this.field_238742_p_ = 76;
    }

    private void openWindow(GuiWindow window, Supplier<? extends GuiElement> elementSupplier) {
        window.setListenerTab(elementSupplier);
        elementSupplier.get().field_230693_o_ = false;
        this.addWindow(window);
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.func_230480_a_(new GuiSecurityTab(this, this.robit, 120));
        this.func_230480_a_(GuiSideHolder.create(this, 176, 6, 106, false, false, SpecialColors.TAB_ROBIT_MENU));
        this.func_230480_a_(new GuiInnerScreen(this, 27, 16, 122, 56));
        this.func_230480_a_(new GuiHorizontalPowerBar((IGuiWrapper)this, this.robit.getEnergyContainer(), 27, 74, 120));
        this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, 6, 16, 18, this.getButtonLocation("home"), () -> {
            Mekanism.packetHandler.sendToServer(new PacketRobit(PacketRobit.RobitPacketType.GO_HOME, this.robit));
            this.getMinecraft().func_147108_a(null);
        }, this.getOnHover(MekanismLang.ROBIT_TELEPORT)));
        this.renameButton = (MekanismImageButton)this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, 6, 35, 18, this.getButtonLocation("rename"), () -> this.openWindow(new GuiRobitRename(this, 27, 16, this.robit), () -> this.renameButton), this.getOnHover(MekanismLang.ROBIT_RENAME)));
        this.skinButton = (MekanismImageButton)this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, 6, 54, 18, this.getButtonLocation("skin"), () -> this.openWindow(new GuiRobitSkinSelect(this, 4, -12, this.robit), () -> this.skinButton), this.getOnHover(MekanismLang.ROBIT_SKIN_SELECT)));
        this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, 152, 35, 18, this.getButtonLocation("drop"), () -> Mekanism.packetHandler.sendToServer(new PacketRobit(PacketRobit.RobitPacketType.DROP_PICKUP, this.robit)), this.getOnHover(MekanismLang.ROBIT_TOGGLE_PICKUP)));
        this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, 152, 54, 18, this.getButtonLocation("follow"), () -> Mekanism.packetHandler.sendToServer(new PacketRobit(PacketRobit.RobitPacketType.FOLLOW, this.robit)), this.getOnHover(MekanismLang.ROBIT_TOGGLE_FOLLOW)));
        this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, 179, 10, 18, this.getButtonLocation("main"), () -> {}, this.getOnHover(MekanismLang.ROBIT)));
        this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, 179, 30, 18, this.getButtonLocation("crafting"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedEntityButton.ROBIT_CRAFTING, (Entity)this.robit)), this.getOnHover(MekanismLang.ROBIT_CRAFTING)));
        this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, 179, 50, 18, this.getButtonLocation("inventory"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedEntityButton.ROBIT_INVENTORY, (Entity)this.robit)), this.getOnHover(MekanismLang.ROBIT_INVENTORY)));
        this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, 179, 70, 18, this.getButtonLocation("smelting"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedEntityButton.ROBIT_SMELTING, (Entity)this.robit)), this.getOnHover(MekanismLang.ROBIT_SMELTING)));
        this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, 179, 90, 18, this.getButtonLocation("repair"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedEntityButton.ROBIT_REPAIR, (Entity)this.robit)), this.getOnHover(MekanismLang.ROBIT_REPAIR)));
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.drawString(matrix, (ITextComponent)MekanismLang.ROBIT.translate(new Object[0]), this.field_238742_p_, this.field_238743_q_, this.titleTextColor());
        this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.ROBIT_GREETING.translate(this.robit.func_200200_C_()), 29.0f, 18.0f, this.screenTextColor(), 119.0f);
        this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.ENERGY.translate(EnergyDisplay.of(this.robit.getEnergyContainer())), 29.0f, 32.0f, this.screenTextColor(), 119.0f);
        this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.ROBIT_FOLLOWING.translate(this.robit.getFollowing()), 29.0f, 41.0f, this.screenTextColor(), 119.0f);
        this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.ROBIT_DROP_PICKUP.translate(this.robit.getDropPickup()), 29.0f, 50.0f, this.screenTextColor(), 119.0f);
        String owner = this.robit.getOwnerName().length() > 14 ? this.robit.getOwnerName().subSequence(0, 14) : this.robit.getOwnerName();
        this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.ROBIT_OWNER.translate(owner), 29.0f, 59.0f, this.screenTextColor(), 119.0f);
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

