/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.tab.GuiBiDirectionalTab;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiEnergyTab
extends GuiBiDirectionalTab {
    private static final Map<UnitDisplayUtils.EnergyType, ResourceLocation> ICONS = new EnumMap<UnitDisplayUtils.EnergyType, ResourceLocation>(UnitDisplayUtils.EnergyType.class);
    private final GuiTexturedElement.IInfoHandler infoHandler;

    public GuiEnergyTab(IGuiWrapper gui, GuiTexturedElement.IInfoHandler handler) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_TAB, "energy_info.png"), gui, -26, 137, 26, 26);
        this.infoHandler = handler;
    }

    public GuiEnergyTab(IGuiWrapper gui, MachineEnergyContainer<?> energyContainer) {
        this(gui, () -> Arrays.asList(MekanismLang.USING.translate(EnergyDisplay.of(energyContainer.getEnergyPerTick())), MekanismLang.NEEDED.translate(EnergyDisplay.of(energyContainer.getNeeded()))));
    }

    public GuiEnergyTab(IGuiWrapper gui, MachineEnergyContainer<?> energyContainer, FloatingLongSupplier lastEnergyUsed) {
        this(gui, () -> Arrays.asList(MekanismLang.USING.translate(EnergyDisplay.of(lastEnergyUsed.get())), MekanismLang.NEEDED.translate(EnergyDisplay.of(energyContainer.getNeeded()))));
    }

    public GuiEnergyTab(IGuiWrapper gui, MachineEnergyContainer<?> energyContainer, BooleanSupplier isActive) {
        this(gui, () -> {
            FloatingLong using = isActive.getAsBoolean() ? energyContainer.getEnergyPerTick() : FloatingLong.ZERO;
            return Arrays.asList(MekanismLang.USING.translate(EnergyDisplay.of(using)), MekanismLang.NEEDED.translate(EnergyDisplay.of(energyContainer.getNeeded())));
        });
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        GuiEnergyTab.minecraft.field_71446_o.func_110577_a(this.getResource());
        GuiEnergyTab.func_238463_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)0.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.field_230688_j_, (int)this.field_230689_k_);
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        super.func_230443_a_(matrix, mouseX, mouseY);
        ArrayList<ITextComponent> info = new ArrayList<ITextComponent>(this.infoHandler.getInfo());
        info.add((ITextComponent)MekanismLang.UNIT.translate(MekanismConfig.general.energyUnit.get()));
        this.displayTooltips(matrix, info, mouseX, mouseY);
    }

    @Override
    protected ResourceLocation getResource() {
        return ICONS.computeIfAbsent((UnitDisplayUtils.EnergyType)MekanismConfig.general.energyUnit.get(), type -> MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_TAB, "energy_info_" + type.name().toLowerCase(Locale.ROOT) + ".png"));
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        MekanismConfig.general.energyUnit.set(((UnitDisplayUtils.EnergyType)MekanismConfig.general.energyUnit.get()).getNext());
    }

    @Override
    protected void onRightClick(double mouseX, double mouseY) {
        MekanismConfig.general.energyUnit.set(((UnitDisplayUtils.EnergyType)MekanismConfig.general.energyUnit.get()).getPrevious());
    }
}

