/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.item.GuiDictionary;
import mekanism.client.jei.interfaces.IJEIGhostTarget;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.base.TagCache;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class GuiDictionaryTarget
extends GuiElement
implements IJEIGhostTarget {
    private final Map<GuiDictionary.DictionaryTagType, List<String>> tags = new EnumMap<GuiDictionary.DictionaryTagType, List<String>>(GuiDictionary.DictionaryTagType.class);
    private final Consumer<Set<GuiDictionary.DictionaryTagType>> tagSetter;
    @Nullable
    private Object target;

    public GuiDictionaryTarget(IGuiWrapper gui, int x, int y, Consumer<Set<GuiDictionary.DictionaryTagType>> tagSetter) {
        super(gui, x, y, 16, 16);
        this.tagSetter = tagSetter;
        this.playClickSound = true;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.target instanceof ItemStack) {
            this.gui().renderItem(matrix, (ItemStack)this.target, this.field_230690_l_, this.field_230691_m_);
        } else if (this.target instanceof FluidStack) {
            FluidStack stack = (FluidStack)this.target;
            MekanismRenderer.color(stack);
            this.drawTiledSprite(matrix, this.field_230690_l_, this.field_230691_m_, this.field_230689_k_, this.field_230688_j_, this.field_230689_k_, MekanismRenderer.getFluidTexture(stack, MekanismRenderer.FluidType.STILL), GuiUtils.TilingDirection.DOWN_RIGHT);
            MekanismRenderer.resetColor();
        } else if (this.target instanceof ChemicalStack) {
            ChemicalStack stack = (ChemicalStack)this.target;
            MekanismRenderer.color(stack);
            this.drawTiledSprite(matrix, this.field_230690_l_, this.field_230691_m_, this.field_230689_k_, this.field_230688_j_, this.field_230689_k_, MekanismRenderer.getChemicalTexture(stack.getType()), GuiUtils.TilingDirection.DOWN_RIGHT);
            MekanismRenderer.resetColor();
        }
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        super.func_230443_a_(matrix, mouseX, mouseY);
        if (this.target instanceof ItemStack) {
            this.gui().renderItemTooltip(matrix, (ItemStack)this.target, mouseX, mouseY);
        } else if (this.target != null) {
            this.displayTooltip(matrix, (ITextComponent)TextComponentUtil.build(this.target), mouseX, mouseY);
        }
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        if (Screen.func_231173_s_()) {
            this.setTargetSlot(null, false);
        } else {
            ItemStack stack = GuiDictionaryTarget.minecraft.field_71439_g.field_71071_by.func_70445_o();
            if (!stack.func_190926_b()) {
                this.setTargetSlot(stack, false);
            }
        }
    }

    public List<String> getTags(GuiDictionary.DictionaryTagType type) {
        return this.tags.getOrDefault(type, Collections.emptyList());
    }

    public void setTargetSlot(Object newTarget, boolean playSound) {
        this.tags.clear();
        if (newTarget == null) {
            this.target = null;
        } else if (newTarget instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)newTarget;
            if (itemStack.func_190926_b()) {
                this.target = null;
            } else {
                Potion potion;
                Map enchantments;
                ItemStack stack = StackUtils.size(itemStack, 1);
                this.target = stack;
                Item item = stack.func_77973_b();
                this.tags.put(GuiDictionary.DictionaryTagType.ITEM, TagCache.getItemTags(stack));
                if (item instanceof BlockItem) {
                    Block block = ((BlockItem)item).func_179223_d();
                    this.tags.put(GuiDictionary.DictionaryTagType.BLOCK, TagCache.getTagsAsStrings(block.getTags()));
                    if (block instanceof IHasTileEntity || block.hasTileEntity(block.func_176223_P())) {
                        this.tags.put(GuiDictionary.DictionaryTagType.TILE_ENTITY_TYPE, TagCache.getTileEntityTypeTags(block));
                    }
                }
                if (item instanceof SpawnEggItem) {
                    this.tags.put(GuiDictionary.DictionaryTagType.ENTITY_TYPE, TagCache.getTagsAsStrings(((SpawnEggItem)item).func_208076_b(stack.func_77978_p()).getTags()));
                }
                if (!(enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack)).isEmpty()) {
                    HashSet<ResourceLocation> enchantmentTags = new HashSet<ResourceLocation>();
                    for (Enchantment enchantment : enchantments.keySet()) {
                        enchantmentTags.addAll(enchantment.getTags());
                    }
                    this.tags.put(GuiDictionary.DictionaryTagType.ENCHANTMENT, TagCache.getTagsAsStrings(enchantmentTags));
                }
                if ((potion = PotionUtils.func_185191_c((ItemStack)itemStack)) != Potions.field_185229_a) {
                    this.tags.put(GuiDictionary.DictionaryTagType.POTION, TagCache.getTagsAsStrings(potion.getTags()));
                }
                FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(fluidHandler -> {
                    HashSet<ResourceLocation> fluidTags = new HashSet<ResourceLocation>();
                    for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                        FluidStack fluidInTank = fluidHandler.getFluidInTank(tank);
                        if (fluidInTank.isEmpty()) continue;
                        fluidTags.addAll(fluidInTank.getFluid().getTags());
                    }
                    this.tags.put(GuiDictionary.DictionaryTagType.FLUID, TagCache.getTagsAsStrings(fluidTags));
                });
                this.addChemicalTags(GuiDictionary.DictionaryTagType.GAS, stack, Capabilities.GAS_HANDLER_CAPABILITY);
                this.addChemicalTags(GuiDictionary.DictionaryTagType.INFUSE_TYPE, stack, Capabilities.INFUSION_HANDLER_CAPABILITY);
                this.addChemicalTags(GuiDictionary.DictionaryTagType.PIGMENT, stack, Capabilities.PIGMENT_HANDLER_CAPABILITY);
                this.addChemicalTags(GuiDictionary.DictionaryTagType.SLURRY, stack, Capabilities.SLURRY_HANDLER_CAPABILITY);
            }
        } else if (newTarget instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)newTarget;
            if (fluidStack.isEmpty()) {
                this.target = null;
            } else {
                this.target = fluidStack.copy();
                this.tags.put(GuiDictionary.DictionaryTagType.FLUID, TagCache.getTagsAsStrings(((FluidStack)this.target).getFluid().getTags()));
            }
        } else if (newTarget instanceof ChemicalStack) {
            ChemicalStack chemicalStack = (ChemicalStack)newTarget;
            if (chemicalStack.isEmpty()) {
                this.target = null;
            } else {
                this.target = chemicalStack.copy();
                List<String> chemicalTags = TagCache.getTagsAsStrings(((Chemical)((ChemicalStack)this.target).getType()).getTags());
                if (this.target instanceof GasStack) {
                    this.tags.put(GuiDictionary.DictionaryTagType.GAS, chemicalTags);
                } else if (this.target instanceof InfusionStack) {
                    this.tags.put(GuiDictionary.DictionaryTagType.INFUSE_TYPE, chemicalTags);
                } else if (this.target instanceof PigmentStack) {
                    this.tags.put(GuiDictionary.DictionaryTagType.PIGMENT, chemicalTags);
                } else if (this.target instanceof SlurryStack) {
                    this.tags.put(GuiDictionary.DictionaryTagType.SLURRY, chemicalTags);
                }
            }
        } else {
            Mekanism.logger.warn("Unable to get tags for unknown type: {}", newTarget);
            return;
        }
        this.tagSetter.accept(this.tags.keySet());
        if (playSound) {
            this.playClickSound();
        }
    }

    private <HANDLER extends IChemicalHandler<?, ?>> void addChemicalTags(GuiDictionary.DictionaryTagType tagType, ItemStack stack, Capability<HANDLER> capability) {
        stack.getCapability(capability).ifPresent(handler -> {
            HashSet<ResourceLocation> chemicalTags = new HashSet<ResourceLocation>();
            for (int tank = 0; tank < handler.getTanks(); ++tank) {
                Object chemicalInTank = handler.getChemicalInTank(tank);
                if (((ChemicalStack)chemicalInTank).isEmpty()) continue;
                chemicalTags.addAll(((Chemical)((ChemicalStack)chemicalInTank).getType()).getTags());
            }
            this.tags.put(tagType, TagCache.getTagsAsStrings(chemicalTags));
        });
    }

    @Override
    public boolean hasPersistentData() {
        return true;
    }

    @Override
    public void syncFrom(GuiElement element) {
        super.syncFrom(element);
        GuiDictionaryTarget old = (GuiDictionaryTarget)element;
        this.target = old.target;
        this.tags.putAll(old.tags);
    }

    @Override
    @Nullable
    public IJEIGhostTarget.IGhostIngredientConsumer getGhostHandler() {
        return new IJEIGhostTarget.IGhostIngredientConsumer(){

            @Override
            public boolean supportsIngredient(Object ingredient) {
                if (ingredient instanceof ItemStack) {
                    return !((ItemStack)ingredient).func_190926_b();
                }
                if (ingredient instanceof FluidStack) {
                    return !((FluidStack)ingredient).isEmpty();
                }
                if (ingredient instanceof ChemicalStack) {
                    return !((ChemicalStack)ingredient).isEmpty();
                }
                return false;
            }

            @Override
            public void accept(Object ingredient) {
                GuiDictionaryTarget.this.setTargetSlot(ingredient, true);
            }
        };
    }
}

