/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache.chemical;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.chemical.FluidChemicalToChemicalRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraftforge.fluids.FluidStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class FluidChemicalToChemicalCachedRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends FluidChemicalToChemicalRecipe<CHEMICAL, STACK, INGREDIENT>>
extends CachedRecipe<RECIPE> {
    private final IOutputHandler<@NonNull STACK> outputHandler;
    private final IInputHandler<@NonNull FluidStack> fluidInputHandler;
    private final IInputHandler<@NonNull STACK> chemicalInputHandler;
    private FluidStack recipeFluid = FluidStack.EMPTY;
    @Nullable
    private STACK recipeChemical;

    public FluidChemicalToChemicalCachedRecipe(RECIPE recipe, IInputHandler<@NonNull FluidStack> fluidInputHandler, IInputHandler<@NonNull STACK> chemicalInputHandler, IOutputHandler<@NonNull STACK> outputHandler) {
        super(recipe);
        this.fluidInputHandler = Objects.requireNonNull(fluidInputHandler, "Fluid input handler cannot be null.");
        this.chemicalInputHandler = Objects.requireNonNull(chemicalInputHandler, "Chemical input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        this.recipeFluid = this.fluidInputHandler.getRecipeInput(((FluidChemicalToChemicalRecipe)this.recipe).getFluidInput());
        if (this.recipeFluid.isEmpty()) {
            return -1;
        }
        this.recipeChemical = (ChemicalStack)this.chemicalInputHandler.getRecipeInput((InputIngredient<STACK>)((FluidChemicalToChemicalRecipe)this.recipe).getChemicalInput());
        if (((ChemicalStack)this.recipeChemical).isEmpty()) {
            return -1;
        }
        currentMax = this.fluidInputHandler.operationsCanSupport(this.recipeFluid, currentMax);
        if ((currentMax = this.chemicalInputHandler.operationsCanSupport(this.recipeChemical, currentMax)) <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((FluidChemicalToChemicalRecipe)this.recipe).getOutput(this.recipeFluid, this.recipeChemical), currentMax);
    }

    @Override
    public boolean isInputValid() {
        FluidStack fluidStack = this.fluidInputHandler.getInput();
        if (fluidStack.isEmpty()) {
            return false;
        }
        ChemicalStack chemicalInput = (ChemicalStack)this.chemicalInputHandler.getInput();
        if (chemicalInput.isEmpty()) {
            return false;
        }
        return ((FluidChemicalToChemicalRecipe)this.recipe).test(fluidStack, chemicalInput);
    }

    @Override
    protected void finishProcessing(int operations) {
        if (this.recipeFluid.isEmpty() || this.recipeChemical == null || ((ChemicalStack)this.recipeChemical).isEmpty()) {
            return;
        }
        this.fluidInputHandler.use(this.recipeFluid, operations);
        this.chemicalInputHandler.use(this.recipeChemical, operations);
        this.outputHandler.handleOutput(((FluidChemicalToChemicalRecipe)this.recipe).getOutput(this.recipeFluid, this.recipeChemical), operations);
    }
}

