/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.Objects;
import java.util.function.LongSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.outputs.BoxedChemicalOutputHandler;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ChemicalDissolutionCachedRecipe
extends CachedRecipe<ChemicalDissolutionRecipe> {
    private final BoxedChemicalOutputHandler outputHandler;
    private final IInputHandler<@NonNull ItemStack> itemInputHandler;
    private final ILongInputHandler<@NonNull GasStack> gasInputHandler;
    private final LongSupplier gasUsage;
    private long gasUsageMultiplier;
    private ItemStack recipeItem = ItemStack.field_190927_a;
    private GasStack recipeGas = GasStack.EMPTY;

    public ChemicalDissolutionCachedRecipe(ChemicalDissolutionRecipe recipe, IInputHandler<@NonNull ItemStack> itemInputHandler, ILongInputHandler<@NonNull GasStack> gasInputHandler, LongSupplier gasUsage, BoxedChemicalOutputHandler outputHandler) {
        super(recipe);
        this.itemInputHandler = Objects.requireNonNull(itemInputHandler, "Item input handler cannot be null.");
        this.gasInputHandler = Objects.requireNonNull(gasInputHandler, "Gas input handler cannot be null.");
        this.gasUsage = Objects.requireNonNull(gasUsage, "Gas usage cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Input handler cannot be null.");
    }

    @Override
    protected void setupVariableValues() {
        this.gasUsageMultiplier = Math.max(this.gasUsage.getAsLong(), 0L);
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        this.recipeItem = this.itemInputHandler.getRecipeInput(((ChemicalDissolutionRecipe)this.recipe).getItemInput());
        if (this.recipeItem.func_190926_b()) {
            return -1;
        }
        this.recipeGas = this.gasInputHandler.getRecipeInput(((ChemicalDissolutionRecipe)this.recipe).getGasInput());
        if (this.recipeGas.isEmpty()) {
            return 0;
        }
        if ((currentMax = this.itemInputHandler.operationsCanSupport(this.recipeItem, currentMax)) <= 0) {
            return -1;
        }
        currentMax = this.gasInputHandler.operationsCanSupport(this.recipeGas, currentMax, this.gasUsageMultiplier);
        return this.outputHandler.operationsRoomFor(((ChemicalDissolutionRecipe)this.recipe).getOutput(this.recipeItem, this.recipeGas), currentMax);
    }

    @Override
    public boolean isInputValid() {
        GasStack gasStack = (GasStack)this.gasInputHandler.getInput();
        if (!gasStack.isEmpty() && ((ChemicalDissolutionRecipe)this.recipe).test(this.itemInputHandler.getInput(), gasStack)) {
            GasStack recipeGas = this.gasInputHandler.getRecipeInput(((ChemicalDissolutionRecipe)this.recipe).getGasInput());
            return !recipeGas.isEmpty() && gasStack.getAmount() >= recipeGas.getAmount();
        }
        return false;
    }

    @Override
    protected void useResources(int operations) {
        super.useResources(operations);
        if (this.gasUsageMultiplier <= 0L) {
            return;
        }
        if (this.recipeGas.isEmpty()) {
            return;
        }
        this.gasInputHandler.use(this.recipeGas, (long)operations * this.gasUsageMultiplier);
    }

    @Override
    protected void finishProcessing(int operations) {
        if (this.recipeItem.func_190926_b() || this.recipeGas.isEmpty()) {
            return;
        }
        this.itemInputHandler.use(this.recipeItem, operations);
        if (this.gasUsageMultiplier > 0L) {
            this.gasInputHandler.use(this.recipeGas, (long)operations * this.gasUsageMultiplier);
        }
        this.outputHandler.handleOutput(((ChemicalDissolutionRecipe)this.recipe).getOutput(this.recipeItem, this.recipeGas), operations);
    }
}

