/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets.to_client;

import javax.annotation.Nullable;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.network.packets.IPEPacket;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SyncEmcPKT
implements IPEPacket {
    private final EmcPKTInfo[] data;

    public SyncEmcPKT(EmcPKTInfo[] data) {
        this.data = data;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        PECore.LOGGER.info("Receiving EMC data from server.");
        EMCMappingHandler.fromPacket(this.data);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.data.length);
        for (EmcPKTInfo info : this.data) {
            buffer.writeRegistryId((IForgeRegistryEntry)info.getItem());
            buffer.func_150786_a(info.getNbt());
            buffer.func_179254_b(info.getEmc());
        }
    }

    public static SyncEmcPKT decode(PacketBuffer buffer) {
        int size = buffer.func_150792_a();
        EmcPKTInfo[] data = new EmcPKTInfo[size];
        for (int i = 0; i < size; ++i) {
            data[i] = new EmcPKTInfo((Item)buffer.readRegistryId(), buffer.func_150793_b(), buffer.func_179260_f());
        }
        return new SyncEmcPKT(data);
    }

    public static class EmcPKTInfo {
        private final Item item;
        private final long emc;
        @Nullable
        private final CompoundNBT nbt;

        public EmcPKTInfo(Item item, @Nullable CompoundNBT nbt, long emc) {
            this.item = item;
            this.emc = emc;
            this.nbt = nbt;
        }

        public Item getItem() {
            return this.item;
        }

        public long getEmc() {
            return this.emc;
        }

        @Nullable
        public CompoundNBT getNbt() {
            return this.nbt;
        }
    }
}

