/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.capability.ProjectileShooterItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityLavaProjectile;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class VolcaniteAmulet
extends ItemPE
implements IProjectileShooter,
IPedestalItem,
IFireProtector {
    public VolcaniteAmulet(Item.Properties props) {
        super(props);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
        this.addItemCapability(ProjectileShooterItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack.func_77946_l();
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        PlayerEntity player = ctx.func_195999_j();
        BlockPos pos = ctx.func_195995_a();
        ItemStack stack = ctx.func_195996_i();
        if (player != null && !world.field_72995_K && PlayerHelper.hasEditPermission((ServerPlayerEntity)player, pos) && VolcaniteAmulet.consumeFuel(player, stack, 32L, true)) {
            Optional capability;
            TileEntity tile = WorldHelper.getTileEntity((IBlockReader)world, pos);
            Direction sideHit = ctx.func_196000_l();
            if (tile != null && (capability = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, sideHit).resolve()).isPresent()) {
                ((IFluidHandler)capability.get()).fill(new FluidStack((Fluid)Fluids.field_204547_b, 1000), IFluidHandler.FluidAction.EXECUTE);
                return ActionResultType.SUCCESS;
            }
            WorldHelper.placeFluid((ServerPlayerEntity)player, world, pos, sideHit, Fluids.field_204547_b, false);
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)PESoundEvents.TRANSMUTE.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public boolean shootProjectile(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, Hand hand) {
        player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)PESoundEvents.TRANSMUTE.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        EntityLavaProjectile ent = new EntityLavaProjectile(player, player.func_130014_f_());
        ent.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
        player.func_130014_f_().func_217376_c((Entity)ent);
        return true;
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltips, @Nonnull ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltips, flags);
        tooltips.add((ITextComponent)PELang.TOOLTIP_VOLCANITE_1.translate(ClientKeyHelper.getKeyName(PEKeybind.FIRE_PROJECTILE)));
        tooltips.add((ITextComponent)PELang.TOOLTIP_VOLCANITE_2.translate(new Object[0]));
        tooltips.add((ITextComponent)PELang.TOOLTIP_VOLCANITE_3.translate(new Object[0]));
        tooltips.add((ITextComponent)PELang.TOOLTIP_VOLCANITE_4.translate(new Object[0]));
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        DMPedestalTile tile;
        if (!world.field_72995_K && ProjectEConfig.server.cooldown.pedestal.volcanite.get() != -1 && (tile = WorldHelper.getTileEntity(DMPedestalTile.class, (IBlockReader)world, pos, true)) != null) {
            if (tile.getActivityCooldown() == 0) {
                if (world.func_72912_H() instanceof IServerWorldInfo) {
                    IServerWorldInfo worldInfo = (IServerWorldInfo)world.func_72912_H();
                    worldInfo.func_76080_g(0);
                    worldInfo.func_76090_f(0);
                    worldInfo.func_76084_b(false);
                    worldInfo.func_76069_a(false);
                }
                tile.setActivityCooldown(ProjectEConfig.server.cooldown.pedestal.volcanite.get());
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (ProjectEConfig.server.cooldown.pedestal.volcanite.get() != -1) {
            list.add((ITextComponent)PELang.PEDESTAL_VOLCANITE_1.translateColored(TextFormatting.BLUE, new Object[0]));
            list.add((ITextComponent)PELang.PEDESTAL_VOLCANITE_2.translateColored(TextFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.volcanite.get())));
        }
        return list;
    }

    @Override
    public boolean canProtectAgainstFire(ItemStack stack, ServerPlayerEntity player) {
        return true;
    }
}

