/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import java.math.BigInteger;
import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.container.PEHandContainer;
import moze_intel.projecte.gameObjs.container.inventory.TransmutationInventory;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotConsume;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotInput;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotLock;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotOutput;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotUnlearn;
import moze_intel.projecte.gameObjs.items.Tome;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.to_server.SearchUpdatePKT;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TransmutationContainer
extends PEHandContainer {
    public final TransmutationInventory transmutationInventory;
    private SlotUnlearn unlearn;

    public static TransmutationContainer fromNetwork(int windowId, PlayerInventory invPlayer, PacketBuffer buf) {
        if (buf.readBoolean()) {
            return new TransmutationContainer(windowId, invPlayer, (Hand)buf.func_179257_a(Hand.class), (int)buf.readByte());
        }
        return new TransmutationContainer(windowId, invPlayer);
    }

    public TransmutationContainer(int windowId, PlayerInventory invPlayer) {
        super(PEContainerTypes.TRANSMUTATION_CONTAINER, windowId, null, 0);
        this.transmutationInventory = new TransmutationInventory(invPlayer.field_70458_d);
        this.initSlots(invPlayer);
    }

    public TransmutationContainer(int windowId, PlayerInventory invPlayer, Hand hand, int selected) {
        super(PEContainerTypes.TRANSMUTATION_CONTAINER, windowId, hand, selected);
        this.transmutationInventory = new TransmutationInventory(invPlayer.field_70458_d);
        this.initSlots(invPlayer);
    }

    private void initSlots(PlayerInventory invPlayer) {
        this.func_75146_a((Slot)new SlotInput(this.transmutationInventory, 0, 43, 23));
        this.func_75146_a((Slot)new SlotInput(this.transmutationInventory, 1, 34, 41));
        this.func_75146_a((Slot)new SlotInput(this.transmutationInventory, 2, 52, 41));
        this.func_75146_a((Slot)new SlotInput(this.transmutationInventory, 3, 16, 50));
        this.func_75146_a((Slot)new SlotInput(this.transmutationInventory, 4, 70, 50));
        this.func_75146_a((Slot)new SlotInput(this.transmutationInventory, 5, 34, 59));
        this.func_75146_a((Slot)new SlotInput(this.transmutationInventory, 6, 52, 59));
        this.func_75146_a((Slot)new SlotInput(this.transmutationInventory, 7, 43, 77));
        this.func_75146_a((Slot)new SlotLock(this.transmutationInventory, 8, 158, 50));
        this.func_75146_a((Slot)new SlotConsume(this.transmutationInventory, 9, 107, 97));
        this.unlearn = new SlotUnlearn(this.transmutationInventory, 10, 89, 97);
        this.func_75146_a((Slot)this.unlearn);
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 11, 158, 9));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 12, 176, 13));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 13, 193, 30));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 14, 199, 50));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 15, 193, 70));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 16, 176, 87));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 17, 158, 91));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 18, 140, 87));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 19, 123, 70));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 20, 116, 50));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 21, 123, 30));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 22, 140, 13));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 23, 158, 31));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 24, 177, 50));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 25, 158, 69));
        this.func_75146_a((Slot)new SlotOutput(this.transmutationInventory, 26, 139, 50));
        this.addPlayerInventory(invPlayer, 35, 117);
    }

    public void func_75134_a(@Nonnull PlayerEntity player) {
        super.func_75134_a(player);
        if (!player.func_70089_S() || player instanceof ServerPlayerEntity && ((ServerPlayerEntity)player).func_193105_t()) {
            player.func_71019_a(this.unlearn.func_75211_c(), false);
        } else {
            player.field_71071_by.func_191975_a(player.field_70170_p, this.unlearn.func_75211_c());
        }
    }

    @Override
    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int slotIndex) {
        if (slotIndex < 9 || slotIndex == 10) {
            return super.func_82846_b(player, slotIndex);
        }
        Slot slot = this.tryGetSlot(slotIndex);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        if (slotIndex >= 11 && slotIndex <= 26) {
            ItemStack stack = slot.func_75211_c().func_77946_l();
            long itemEmc = EMCHelper.getEmcValue(stack);
            if (itemEmc > 0L) {
                stack.func_190920_e(stack.func_77976_d());
                int stackSize = stack.func_190916_E() - ItemHelper.simulateFit((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, stack);
                if (stackSize > 0) {
                    BigInteger availableEMC = this.transmutationInventory.getAvailableEmc();
                    BigInteger emc = BigInteger.valueOf(itemEmc);
                    BigInteger totalEmc = emc.multiply(BigInteger.valueOf(stackSize));
                    if (totalEmc.compareTo(availableEMC) > 0) {
                        BigInteger numOperations = availableEMC.divide(emc);
                        stackSize = numOperations.intValueExact();
                        totalEmc = emc.multiply(numOperations);
                        if (stackSize <= 0) {
                            return ItemStack.field_190927_a;
                        }
                    }
                    stack.func_190920_e(stackSize);
                    IItemHandler inv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(NullPointerException::new);
                    if (this.transmutationInventory.isServer()) {
                        this.transmutationInventory.removeEmc(totalEmc);
                    }
                    ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)false);
                }
            }
        } else if (slotIndex > 26) {
            ItemStack stack = slot.func_75211_c().func_77946_l();
            long emc = EMCHelper.getEmcSellValue(stack);
            if (emc == 0L && !(stack.func_77973_b() instanceof Tome)) {
                return ItemStack.field_190927_a;
            }
            if (this.transmutationInventory.isServer()) {
                BigInteger emcBigInt = BigInteger.valueOf(emc);
                this.transmutationInventory.handleKnowledge(stack);
                this.transmutationInventory.addEmc(emcBigInt.multiply(BigInteger.valueOf(stack.func_190916_E())));
            }
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    @Nonnull
    public ItemStack clickPostValidate(int slotIndex, int dragType, @Nonnull ClickType clickType, @Nonnull PlayerEntity player) {
        Slot slot;
        if (player.func_130014_f_().field_72995_K && this.transmutationInventory.getHandlerForSlot(slotIndex) == this.transmutationInventory.outputs && (slot = this.tryGetSlot(slotIndex)) != null) {
            PacketHandler.sendToServer(new SearchUpdatePKT(this.transmutationInventory.getIndexFromSlot(slotIndex), slot.func_75211_c()));
        }
        return super.clickPostValidate(slotIndex, dragType, clickType, player);
    }

    public boolean func_94531_b(@Nonnull Slot slot) {
        return !(slot instanceof SlotConsume) && !(slot instanceof SlotUnlearn) && !(slot instanceof SlotInput) && !(slot instanceof SlotLock) && !(slot instanceof SlotOutput);
    }
}

