/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.util;

import codechicken.lib.capability.NullStorage;
import codechicken.lib.capability.SimpleCapProvider;
import codechicken.lib.capability.SimpleCapProviderSerializable;
import codechicken.lib.util.CrashLock;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.api.part.TRandomTickPart;
import codechicken.multipart.util.WorldTickScheduler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ChunkEvent;

public class TickScheduler {
    private static final CrashLock LOCK = new CrashLock("Already initialized.");
    @CapabilityInject(value=WorldTickScheduler.class)
    private static Capability<WorldTickScheduler> WORLD_CAPABILITY = null;
    @CapabilityInject(value=WorldTickScheduler.ChunkScheduler.class)
    private static Capability<WorldTickScheduler.ChunkScheduler> CHUNK_CAPABILITY = null;
    private static final ResourceLocation WORLD_KEY = new ResourceLocation("cb_multipart", "world_scheduled_ticks");
    private static final ResourceLocation CHUNK_KEY = new ResourceLocation("cb_multipart", "chunk_scheduled_ticks");

    public static void init() {
        LOCK.lock();
        MinecraftForge.EVENT_BUS.addGenericListener(World.class, TickScheduler::attachWorldCapabilities);
        MinecraftForge.EVENT_BUS.addGenericListener(Chunk.class, TickScheduler::attachChunkCapabilities);
        MinecraftForge.EVENT_BUS.addListener(TickScheduler::onChunkLoad);
        MinecraftForge.EVENT_BUS.addListener(TickScheduler::onChunkUnload);
        MinecraftForge.EVENT_BUS.addListener(TickScheduler::onWorldTick);
        CapabilityManager.INSTANCE.register(WorldTickScheduler.class, (Capability.IStorage)new NullStorage(), () -> null);
        CapabilityManager.INSTANCE.register(WorldTickScheduler.ChunkScheduler.class, (Capability.IStorage)new WorldTickScheduler.ChunkStorage(), () -> null);
    }

    private static void attachWorldCapabilities(AttachCapabilitiesEvent<World> event) {
        if (!(event.getObject() instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)event.getObject();
        WorldTickScheduler scheduler = new WorldTickScheduler(world);
        event.addCapability(WORLD_KEY, (ICapabilityProvider)new SimpleCapProvider(WORLD_CAPABILITY, (Object)scheduler));
    }

    private static void attachChunkCapabilities(AttachCapabilitiesEvent<Chunk> event) {
        if (!(((Chunk)event.getObject()).func_177412_p() instanceof ServerWorld)) {
            return;
        }
        ServerWorld level = (ServerWorld)((Chunk)event.getObject()).func_177412_p();
        WorldTickScheduler worldScheduler = WorldTickScheduler.getInstance(level);
        WorldTickScheduler.ChunkScheduler scheduler = new WorldTickScheduler.ChunkScheduler(worldScheduler, (Chunk)event.getObject());
        event.addCapability(CHUNK_KEY, (ICapabilityProvider)new SimpleCapProviderSerializable(CHUNK_CAPABILITY, (Object)scheduler));
    }

    private static void onChunkLoad(ChunkEvent.Load event) {
        Chunk chunk;
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        IChunk iChunk = event.getChunk();
        if (iChunk instanceof Chunk) {
            chunk = (Chunk)iChunk;
        } else if (iChunk instanceof ChunkPrimerWrapper) {
            chunk = ((ChunkPrimerWrapper)iChunk).func_217336_u();
        } else {
            return;
        }
        WorldTickScheduler.ChunkScheduler chunkScheduler = WorldTickScheduler.getInstance(chunk);
        chunkScheduler.onChunkLoad();
    }

    private static void onChunkUnload(ChunkEvent.Unload event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        WorldTickScheduler worldScheduler = WorldTickScheduler.getInstance((ServerWorld)event.getWorld());
        worldScheduler.onChunkUnload(event.getChunk().func_76632_l());
    }

    private static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!(event.world instanceof ServerWorld) || event.phase != TickEvent.Phase.END) {
            return;
        }
        WorldTickScheduler worldScheduler = WorldTickScheduler.getInstance((ServerWorld)event.world);
        worldScheduler.tick();
    }

    public static void scheduleTick(TMultiPart part, int ticks) {
        IChunk chunk;
        if (part.world() instanceof ServerWorld && (chunk = part.world().func_217349_x(part.pos())) instanceof Chunk) {
            WorldTickScheduler.ChunkScheduler chunkScheduler = WorldTickScheduler.getInstance((Chunk)chunk);
            chunkScheduler.addScheduledTick(part, ticks);
        }
    }

    public static void loadRandomTick(TRandomTickPart part) {
        IChunk chunk;
        TMultiPart thePart = (TMultiPart)((Object)part);
        if (thePart.world() instanceof ServerWorld && (chunk = thePart.world().func_217349_x(thePart.pos())) instanceof Chunk) {
            TickScheduler.loadRandomTick(part, (Chunk)chunk);
        }
    }

    public static void loadRandomTick(TRandomTickPart part, Chunk chunk) {
        TMultiPart thePart = (TMultiPart)((Object)part);
        WorldTickScheduler.ChunkScheduler chunkScheduler = WorldTickScheduler.getInstance(chunk);
        chunkScheduler.loadRandomTick(thePart);
    }
}

