/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.network;

import codechicken.lib.data.MCByteStream;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.util.LazyValuePair;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.block.TileMultiPart;
import codechicken.multipart.handler.PlacementConversionHandler;
import codechicken.multipart.init.MultiPartRegistries;
import codechicken.multipart.network.MultiPartNetwork;
import codechicken.multipart.util.ControlKeyModifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Pair;

public class MultiPartSPH
implements ICustomPacketHandler.IServerPacketHandler {
    public void handlePacket(PacketCustom packet, ServerPlayerEntity sender, IServerPlayNetHandler handler) {
        switch (packet.getType()) {
            case 1: {
                ControlKeyModifier.setIsControlDown((PlayerEntity)sender, packet.readBoolean());
                break;
            }
            case 10: {
                PlacementConversionHandler.place((PlayerEntity)sender, packet.readBoolean() ? Hand.MAIN_HAND : Hand.OFF_HAND, sender.field_70170_p);
            }
        }
    }

    public static void sendDescUpdate(TileMultiPart tile) {
        ServerWorld world = (ServerWorld)tile.func_145831_w();
        Stream players = world.func_72863_F().field_217237_a.func_219097_a(new ChunkPos(tile.func_174877_v()), false);
        MultiPartSPH.sendDescUpdates(players, Collections.singleton(tile));
    }

    public static void sendDescUpdates(Stream<ServerPlayerEntity> players, Collection<TileEntity> tiles) {
        if (tiles.isEmpty()) {
            return;
        }
        List data = tiles.stream().filter(e -> e instanceof TileMultiPart).map(e -> (TileMultiPart)((Object)e)).map(tile -> LazyValuePair.of((Object)tile, t -> {
            MCByteStream stream = new MCByteStream();
            t.writeDesc((MCDataOutput)stream);
            return stream;
        })).collect(Collectors.toList());
        if (data.isEmpty()) {
            return;
        }
        players.forEach(player -> MultiPartSPH.sendDescUpdateTo(player, data));
    }

    private static void sendDescUpdateTo(ServerPlayerEntity player, List<Pair<TileMultiPart, MCByteStream>> data) {
        PacketCustom packet = new PacketCustom(MultiPartNetwork.NET_CHANNEL, 1);
        packet.writeVarInt(data.size());
        for (Pair<TileMultiPart, MCByteStream> entry : data) {
            packet.writePos(((TileMultiPart)((Object)entry.getLeft())).func_174877_v());
            packet.append(((MCByteStream)entry.getRight()).getBytes());
        }
        packet.sendToPlayer(player);
    }

    public static void sendAddPart(TileMultiPart tile, TMultiPart part) {
        ServerWorld world = (ServerWorld)tile.func_145831_w();
        MCByteStream stream = new MCByteStream();
        MultiPartRegistries.writePart((MCDataOutput)stream, part);
        world.func_72863_F().field_217237_a.func_219097_a(new ChunkPos(tile.func_174877_v()), false).forEach(player -> {
            PacketCustom packet = new PacketCustom(MultiPartNetwork.NET_CHANNEL, 2);
            packet.writePos(tile.func_174877_v());
            packet.append(stream.getBytes());
            packet.sendToPlayer(player);
        });
    }

    public static void sendRemPart(TileMultiPart tile, int partIdx) {
        ServerWorld world = (ServerWorld)tile.func_145831_w();
        world.func_72863_F().field_217237_a.func_219097_a(new ChunkPos(tile.func_174877_v()), false).forEach(player -> {
            PacketCustom packet = new PacketCustom(MultiPartNetwork.NET_CHANNEL, 3);
            packet.writeByte(partIdx);
            packet.writePos(tile.func_174877_v());
            packet.sendToPlayer(player);
        });
    }

    public static void dispatchPartUpdate(TMultiPart part, Consumer<MCDataOutput> func) {
        ServerWorld world = (ServerWorld)part.world();
        MCByteStream stream = new MCByteStream();
        func.accept((MCDataOutput)stream);
        BlockPos pos = part.pos();
        world.func_72863_F().field_217237_a.func_219097_a(new ChunkPos(pos), false).forEach(player -> {
            PacketCustom packet = new PacketCustom(MultiPartNetwork.NET_CHANNEL, 4);
            packet.writeByte(part.tile().getPartList().indexOf(part));
            packet.writePos(part.pos());
            packet.append(stream.getBytes());
            packet.sendToPlayer(player);
        });
    }
}

