/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.multipart.api.MultiPartType;
import codechicken.multipart.api.part.redstone.IFaceRedstonePart;
import codechicken.multipart.minecraft.McSidedStatePart;
import codechicken.multipart.minecraft.ModContent;
import codechicken.multipart.util.PartRayTraceResult;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IWorld;

public class ButtonPart
extends McSidedStatePart
implements IFaceRedstonePart {
    private final MultiPartType<?> type;
    private final AbstractButtonBlock block;

    public ButtonPart(MultiPartType<?> type, AbstractButtonBlock block) {
        this(type, block, block.func_176223_P());
    }

    public ButtonPart(MultiPartType<?> type, AbstractButtonBlock block, BlockState state) {
        super(state);
        this.type = type;
        this.block = block;
    }

    @Override
    public MultiPartType<?> getType() {
        return this.type;
    }

    @Override
    public BlockState defaultBlockState() {
        return this.block.func_176223_P();
    }

    @Override
    public ItemStack getDropStack() {
        return new ItemStack((IItemProvider)this.block);
    }

    @Override
    public Direction getSide() {
        return HorizontalFaceBlock.func_196365_i((BlockState)this.state).func_176734_d();
    }

    public int delay() {
        return this.sensitive() ? 30 : 20;
    }

    public boolean sensitive() {
        return this.block.field_150047_a;
    }

    @Override
    public ActionResultType activate(PlayerEntity player, PartRayTraceResult hit, ItemStack item, Hand hand) {
        if (this.pressed()) {
            return ActionResultType.CONSUME;
        }
        if (!this.world().field_72995_K) {
            this.toggle();
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void scheduledTick() {
        if (this.pressed()) {
            this.updateState();
        }
    }

    public boolean pressed() {
        return (Boolean)this.state.func_177229_b((Property)AbstractButtonBlock.field_176584_b);
    }

    @Override
    public void onEntityCollision(Entity entity) {
        if (!this.pressed() && !this.world().field_72995_K && entity instanceof ArrowEntity) {
            this.updateState();
        }
    }

    private void toggle() {
        this.state = (BlockState)this.state.func_235896_a_((Property)AbstractButtonBlock.field_176584_b);
        boolean on = this.pressed();
        this.block.func_196367_a(null, (IWorld)this.world(), this.pos(), on);
        if (on) {
            this.scheduleTick(this.delay());
        }
        this.sendUpdate(this::writeDesc);
        this.tile().func_70296_d();
        this.tile().notifyPartChange(this);
        this.tile().notifyNeighborChange(this.getSide().ordinal());
    }

    private void updateState() {
        boolean pressed;
        boolean arrows = this.sensitive() && !this.world().func_217357_a(ArrowEntity.class, this.getShape(ISelectionContext.func_216377_a()).func_197752_a().func_186670_a(this.pos())).isEmpty();
        if (arrows != (pressed = this.pressed())) {
            this.toggle();
        }
        if (arrows && pressed) {
            this.scheduleTick(this.delay());
        }
    }

    @Override
    public void onRemoved() {
        if (this.pressed()) {
            this.tile().notifyNeighborChange(this.getSide().ordinal());
        }
    }

    @Override
    public int weakPowerLevel(int side) {
        return this.pressed() ? 15 : 0;
    }

    @Override
    public int strongPowerLevel(int side) {
        return this.pressed() && side == this.getSide().ordinal() ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return true;
    }

    @Override
    public int getFace() {
        return this.getSide().ordinal();
    }

    public static class DarkOakButtonPart
    extends ButtonPart {
        public DarkOakButtonPart() {
            super(ModContent.darkOakButtonPartType, (AbstractButtonBlock)Blocks.field_196699_eK);
        }

        public DarkOakButtonPart(BlockState state) {
            super(ModContent.darkOakButtonPartType, (AbstractButtonBlock)Blocks.field_196699_eK, state);
        }
    }

    public static class AcaciaButtonPart
    extends ButtonPart {
        public AcaciaButtonPart() {
            super(ModContent.acaciaButtonPartType, (AbstractButtonBlock)Blocks.field_196697_eJ);
        }

        public AcaciaButtonPart(BlockState state) {
            super(ModContent.acaciaButtonPartType, (AbstractButtonBlock)Blocks.field_196697_eJ, state);
        }
    }

    public static class JungleButtonPart
    extends ButtonPart {
        public JungleButtonPart() {
            super(ModContent.jungleButtonPartType, (AbstractButtonBlock)Blocks.field_196695_eI);
        }

        public JungleButtonPart(BlockState state) {
            super(ModContent.jungleButtonPartType, (AbstractButtonBlock)Blocks.field_196695_eI, state);
        }
    }

    public static class BirchButtonPart
    extends ButtonPart {
        public BirchButtonPart() {
            super(ModContent.birchButtonPartType, (AbstractButtonBlock)Blocks.field_196693_eH);
        }

        public BirchButtonPart(BlockState state) {
            super(ModContent.birchButtonPartType, (AbstractButtonBlock)Blocks.field_196693_eH, state);
        }
    }

    public static class SpruceButtonPart
    extends ButtonPart {
        public SpruceButtonPart() {
            super(ModContent.spruceButtonPartType, (AbstractButtonBlock)Blocks.field_196691_eG);
        }

        public SpruceButtonPart(BlockState state) {
            super(ModContent.spruceButtonPartType, (AbstractButtonBlock)Blocks.field_196691_eG, state);
        }
    }

    public static class OakButtonPart
    extends ButtonPart {
        public OakButtonPart() {
            super(ModContent.oakButtonPartType, (AbstractButtonBlock)Blocks.field_196689_eF);
        }

        public OakButtonPart(BlockState state) {
            super(ModContent.oakButtonPartType, (AbstractButtonBlock)Blocks.field_196689_eF, state);
        }
    }

    public static class StoneButtonPart
    extends ButtonPart {
        public StoneButtonPart() {
            super(ModContent.stoneButtonPartType, (AbstractButtonBlock)Blocks.field_150430_aB);
        }

        public StoneButtonPart(BlockState state) {
            super(ModContent.stoneButtonPartType, (AbstractButtonBlock)Blocks.field_150430_aB, state);
        }
    }
}

