/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.tab;

import com.google.common.base.Stopwatch;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class AdvancedTitaniumTab
extends TitaniumTab {
    private static final ItemStack defaultIconStack = new ItemStack((IItemProvider)Blocks.field_180401_cv);
    private List<ItemStack> icons = new ArrayList<ItemStack>();
    private ItemStack currentIcon;
    private int current;
    private Stopwatch watch;
    private Random random;
    private boolean shouldRandomise;

    public AdvancedTitaniumTab(String label, boolean randomise) {
        super(label, null);
        this.stackSupplier = this::getCurrentIcon;
        this.shouldRandomise = randomise;
        this.watch = Stopwatch.createStarted();
        this.random = new Random();
    }

    private void updateIcon() {
        if (this.icons.size() > 0) {
            if (this.watch.elapsed(TimeUnit.MILLISECONDS) >= 1500L) {
                this.watch.reset().start();
                if (this.shouldRandomise) {
                    this.currentIcon = this.icons.get(this.random.nextInt(this.icons.size()));
                } else {
                    this.currentIcon = this.icons.get(this.current++);
                    if (this.current >= this.icons.size()) {
                        this.current = 0;
                    }
                }
            }
        } else {
            this.currentIcon = defaultIconStack;
        }
    }

    public void addIconStacks(Collection<ItemStack> icons) {
        this.icons.addAll(icons);
    }

    public void addIconStack(ItemStack icon) {
        this.icons.add(icon);
    }

    public void addIconStacks(ItemStack ... icons) {
        Collections.addAll(this.icons, icons);
    }

    @Nonnull
    private ItemStack getCurrentIcon() {
        this.updateIcon();
        return this.currentIcon;
    }
}

