/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.block;

import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class BlockGeometry {
    public static List<BlockPos> getPlane(Direction direction, int radius) {
        return BlockGeometry.getPlane(direction.func_176740_k(), radius);
    }

    public static List<BlockPos> getPlane(Direction.Axis axis, int radius) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        int xRadius = axis == Direction.Axis.X ? 0 : radius;
        int yRadius = axis == Direction.Axis.Y ? 0 : radius;
        int zRadius = axis == Direction.Axis.Z ? 0 : radius;
        for (int xx = -xRadius; xx <= xRadius; ++xx) {
            for (int yy = -yRadius; yy <= yRadius; ++yy) {
                for (int zz = -zRadius; zz <= zRadius; ++zz) {
                    out.add(new BlockPos(xx, yy, zz));
                }
            }
        }
        return out;
    }

    public static List<BlockPos> getSphere(double radius) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        Vector3 vFrom = new Vector3(0.5, 0.5, 0.5);
        double dst = radius * radius;
        int toX = MathHelper.func_76143_f((double)radius);
        int toY = MathHelper.func_76143_f((double)radius);
        int toZ = MathHelper.func_76143_f((double)radius);
        for (int y = MathHelper.func_76128_c((double)(-radius)); y <= toY; ++y) {
            for (int x = MathHelper.func_76128_c((double)(-radius)); x <= toX; ++x) {
                for (int z = MathHelper.func_76128_c((double)(-radius)); z <= toZ; ++z) {
                    Vector3 result = new Vector3(x, y, z).add(0.5, 0.5, 0.5);
                    if (!(result.distanceSquared(vFrom) <= dst)) continue;
                    out.add(result.toBlockPos());
                }
            }
        }
        return out;
    }

    public static List<BlockPos> getHollowSphere(double outerRadius, double innerRadius) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        Vector3 vFrom = new Vector3(0.5, 0.5, 0.5);
        double dstOuter = outerRadius * outerRadius;
        double dstInner = innerRadius * innerRadius;
        int toX = MathHelper.func_76143_f((double)outerRadius);
        int toY = MathHelper.func_76143_f((double)outerRadius);
        int toZ = MathHelper.func_76143_f((double)outerRadius);
        for (int x = MathHelper.func_76128_c((double)(-outerRadius)); x <= toX; ++x) {
            for (int y = MathHelper.func_76128_c((double)(-outerRadius)); y <= toY; ++y) {
                for (int z = MathHelper.func_76128_c((double)(-outerRadius)); z <= toZ; ++z) {
                    Vector3 result = new Vector3(x, y, z).add(0.5, 0.5, 0.5);
                    double dst = result.distanceSquared(vFrom);
                    if (!(dst > dstInner) || !(dst <= dstOuter)) continue;
                    out.add(result.toBlockPos());
                }
            }
        }
        return out;
    }

    public static List<BlockPos> getHollowDome(double outerRadius, double innerRadius) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        Vector3 vFrom = new Vector3(0.5, 0.5, 0.5);
        double dstOuter = outerRadius * outerRadius;
        double dstInner = innerRadius * innerRadius;
        int toX = MathHelper.func_76143_f((double)outerRadius);
        int toY = MathHelper.func_76143_f((double)outerRadius);
        int toZ = MathHelper.func_76143_f((double)outerRadius);
        for (int x = MathHelper.func_76128_c((double)(-outerRadius)); x <= toX; ++x) {
            for (int z = MathHelper.func_76128_c((double)(-outerRadius)); z <= toZ; ++z) {
                for (int y = 0; y <= toY; ++y) {
                    Vector3 result = new Vector3(x, y, z).add(0.5, 0.5, 0.5);
                    double dst = result.distanceSquared(vFrom);
                    if (!(dst > dstInner) || !(dst <= dstOuter)) continue;
                    out.add(result.toBlockPos());
                }
            }
        }
        return out;
    }

    public static List<BlockPos> getVerticalCone(BlockPos offset, int flatRadius) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        int lX = offset.func_177958_n() - flatRadius;
        int hX = offset.func_177958_n() + flatRadius;
        int lZ = offset.func_177952_p() - flatRadius;
        int hZ = offset.func_177952_p() + flatRadius;
        for (int yy = offset.func_177956_o(); yy > 0; --yy) {
            for (int xx = lX; xx <= hX; ++xx) {
                for (int zz = lZ; zz <= hZ; ++zz) {
                    double dZ;
                    float perc = (float)yy / (float)offset.func_177956_o();
                    float dstAllowed = (float)flatRadius * perc;
                    double dX = offset.func_177958_n() - xx;
                    double dstCur = Math.sqrt(dX * dX + (dZ = (double)(offset.func_177952_p() - zz)) * dZ);
                    if (!(dstCur <= (double)dstAllowed)) continue;
                    out.add(new BlockPos(xx, yy, zz));
                }
            }
        }
        return out;
    }
}

