/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.transmission.base;

import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightTransmissionHandler;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionWorldHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.NodeConnection;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionProvider;
import hellfirepvp.astralsorcery.common.util.RaytraceAssist;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.dispenser.IPosition;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class SimplePrismTransmissionNode
implements IPrismTransmissionNode {
    private boolean ignoreBlockCollision = false;
    private BlockPos thisPos;
    private final Set<BlockPos> sourcesToThis = new HashSet<BlockPos>();
    private final Map<BlockPos, PrismNext> nextNodes = new HashMap<BlockPos, PrismNext>();

    public SimplePrismTransmissionNode(BlockPos thisPos) {
        this.thisPos = thisPos;
    }

    @Override
    public BlockPos getLocationPos() {
        return this.thisPos;
    }

    public void updateIgnoreBlockCollisionState(World world, boolean ignoreBlockCollision) {
        this.ignoreBlockCollision = ignoreBlockCollision;
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler(world);
        if (handle != null) {
            boolean anyChange = false;
            for (PrismNext next : this.nextNodes.values()) {
                boolean oldState = next.reachable;
                next.reachable = ignoreBlockCollision || next.rayAssist.isClear(world);
                if (next.reachable == oldState) continue;
                anyChange = true;
            }
            if (anyChange) {
                handle.notifyTransmissionNodeChange(this);
            }
        }
    }

    public boolean ignoresBlockCollision() {
        return this.ignoreBlockCollision;
    }

    @Override
    public boolean notifyUnlink(World world, BlockPos to) {
        return this.nextNodes.remove(to) != null;
    }

    @Override
    public void notifyLink(World world, BlockPos pos) {
        this.addLink(world, pos, true, false);
    }

    private void addLink(World world, BlockPos pos, boolean doRayCheck, boolean previousRayState) {
        PrismNext nextNode = new PrismNext(this, world, this.thisPos, pos, doRayCheck, previousRayState);
        this.nextNodes.put(pos, nextNode);
    }

    @Override
    public boolean notifyBlockChange(World world, BlockPos at) {
        boolean anyChange = false;
        for (PrismNext next : this.nextNodes.values()) {
            if (!next.notifyBlockPlace(world, this.thisPos, at)) continue;
            anyChange = true;
        }
        return anyChange;
    }

    @Override
    public void notifySourceLink(World world, BlockPos source) {
        this.sourcesToThis.add(source);
    }

    @Override
    public void notifySourceUnlink(World world, BlockPos source) {
        this.sourcesToThis.remove(source);
    }

    @Override
    public List<NodeConnection<IPrismTransmissionNode>> queryNext(WorldNetworkHandler handler) {
        LinkedList<NodeConnection<IPrismTransmissionNode>> nodes = new LinkedList<NodeConnection<IPrismTransmissionNode>>();
        for (BlockPos pos : this.nextNodes.keySet()) {
            nodes.add(new NodeConnection<IPrismTransmissionNode>(handler.getTransmissionNode(pos), pos, this.nextNodes.get(pos).reachable));
        }
        return nodes;
    }

    @Override
    public List<BlockPos> getSources() {
        return new LinkedList<BlockPos>(this.sourcesToThis);
    }

    @Override
    public TransmissionProvider getProvider() {
        return new Provider();
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        this.thisPos = NBTHelper.readBlockPosFromNBT(compound);
        this.sourcesToThis.clear();
        this.ignoreBlockCollision = compound.func_74767_n("ignoreBlockCollision");
        ListNBT list = compound.func_150295_c("sources", 10);
        for (int i = 0; i < list.size(); ++i) {
            this.sourcesToThis.add(NBTHelper.readBlockPosFromNBT(list.func_150305_b(i)));
        }
        ListNBT nextList = compound.func_150295_c("nextList", 10);
        for (int i = 0; i < nextList.size(); ++i) {
            CompoundNBT tag = nextList.func_150305_b(i);
            BlockPos next = NBTHelper.readBlockPosFromNBT(tag);
            boolean oldState = tag.func_74767_n("rayState");
            this.addLink(null, next, false, oldState);
        }
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        NBTHelper.writeBlockPosToNBT(this.thisPos, compound);
        compound.func_74757_a("ignoreBlockCollision", this.ignoreBlockCollision);
        ListNBT sources = new ListNBT();
        for (BlockPos source : this.sourcesToThis) {
            CompoundNBT comp = new CompoundNBT();
            NBTHelper.writeBlockPosToNBT(source, comp);
            sources.add((Object)comp);
        }
        compound.func_218657_a("sources", (INBT)sources);
        ListNBT nextList = new ListNBT();
        for (BlockPos next : this.nextNodes.keySet()) {
            PrismNext prism = this.nextNodes.get(next);
            CompoundNBT pos = new CompoundNBT();
            NBTHelper.writeBlockPosToNBT(next, pos);
            pos.func_74757_a("rayState", prism.reachable);
            nextList.add((Object)pos);
        }
        compound.func_218657_a("nextList", (INBT)nextList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimplePrismTransmissionNode that = (SimplePrismTransmissionNode)o;
        return Objects.equals(this.thisPos, that.thisPos);
    }

    public int hashCode() {
        return this.thisPos != null ? this.thisPos.hashCode() : 0;
    }

    public static class Provider
    extends TransmissionProvider {
        @Override
        public IPrismTransmissionNode get() {
            return new SimplePrismTransmissionNode(null);
        }
    }

    private static class PrismNext {
        private final SimplePrismTransmissionNode parent;
        private boolean reachable;
        private double distanceSq;
        private final BlockPos pos;
        private RaytraceAssist rayAssist;

        private PrismNext(SimplePrismTransmissionNode parent, World world, BlockPos start, BlockPos end, boolean doRayTest, boolean oldRayState) {
            this.parent = parent;
            this.pos = end;
            this.rayAssist = new RaytraceAssist(start, end);
            this.reachable = doRayTest ? parent.ignoreBlockCollision || this.rayAssist.isClear(world) : oldRayState;
            this.distanceSq = end.func_218138_a((IPosition)Vector3d.func_237491_b_((Vector3i)start), false);
        }

        private boolean notifyBlockPlace(World world, BlockPos connect, BlockPos at) {
            Vector3d bPosAt = Vector3d.func_237491_b_((Vector3i)at);
            double dstStart = connect.func_218138_a((IPosition)bPosAt, false);
            double dstEnd = this.pos.func_218138_a((IPosition)bPosAt, false);
            if (dstStart > this.distanceSq || dstEnd > this.distanceSq) {
                return false;
            }
            boolean oldState = this.reachable;
            this.reachable = this.parent.ignoreBlockCollision || this.rayAssist.isClear(world);
            return this.reachable != oldState;
        }
    }
}

