/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.KeyPerk;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class KeyDamageEffects
extends KeyPerk {
    private static final float defaultApplicationChance = 0.08f;
    public static final Config CONFIG = new Config("key.damage_effects");

    public KeyDamageEffects(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    @Override
    public void attachListeners(LogicalSide side, IEventBus bus) {
        super.attachListeners(side, bus);
        bus.addListener(EventPriority.LOWEST, this::onDamageResult);
    }

    private void onDamageResult(LivingDamageEvent event) {
        LogicalSide side;
        PlayerEntity player;
        PlayerProgress prog;
        DamageSource source = event.getSource();
        if (source.func_76346_g() != null && source.func_76346_g() instanceof PlayerEntity && (prog = ResearchHelper.getProgress(player = (PlayerEntity)source.func_76346_g(), side = this.getSide((Entity)player))).getPerkData().hasPerkEffect(this)) {
            LivingEntity attacked = event.getEntityLiving();
            float chance = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT, ((Double)CONFIG.applicationChance.get()).floatValue());
            if (rand.nextFloat() < chance) {
                switch (rand.nextInt(3)) {
                    case 0: {
                        attacked.func_195064_c(new EffectInstance(Effects.field_82731_v, 200, 1, false, false, true));
                        break;
                    }
                    case 1: {
                        attacked.func_195064_c(new EffectInstance(Effects.field_76436_u, 200, 1, false, false, true));
                        break;
                    }
                    case 2: {
                        attacked.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 1, false, false, true));
                        attacked.func_195064_c(new EffectInstance(Effects.field_76437_t, 200, 1, false, false, true));
                        break;
                    }
                }
            }
        }
    }

    public static class Config
    extends ConfigEntry {
        private ForgeConfigSpec.DoubleValue applicationChance;

        private Config(String section) {
            super(section);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.applicationChance = cfgBuilder.comment("Defines the chance per hit to apply additional effects.").translation(this.translationKey("applicationChance")).defineInRange("applicationChance", (double)0.08f, (double)0.01f, (double)0.2f);
        }
    }
}

